/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.hono.deviceregistry.mongodb.ApplicationConfig;
import org.eclipse.hono.service.AbstractBaseApplication;
import org.eclipse.hono.service.HealthCheckProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Import;

@ComponentScans(value={@ComponentScan(basePackages={"org.eclipse.hono.service.auth"}, excludeFilters={@ComponentScan.Filter(value={Deprecated.class})}), @ComponentScan(basePackages={"org.eclipse.hono.service.metric"}, excludeFilters={@ComponentScan.Filter(value={Deprecated.class})})})
@Import(value={ApplicationConfig.class})
@EnableAutoConfiguration
public class Application
extends AbstractBaseApplication {
    private List<Verticle> verticles;
    private List<HealthCheckProvider> healthCheckProviders;

    @Autowired
    public void setVerticles(List<Verticle> verticles) {
        this.verticles = verticles;
    }

    @Autowired
    public void setHealthCheckProviders(List<HealthCheckProvider> healthCheckProviders) {
        this.healthCheckProviders = healthCheckProviders;
    }

    protected final Future<?> deployVerticles() {
        return super.deployVerticles().compose(ok -> {
            LinkedList<Future> futures = new LinkedList<Future>();
            for (Verticle verticle : this.verticles) {
                this.log.info("deploying verticle: {}", (Object)verticle);
                Promise result = Promise.promise();
                this.getVertx().deployVerticle(verticle, (Handler)result);
                futures.add(result.future());
            }
            return CompositeFuture.all(futures);
        });
    }

    protected Future<Void> postRegisterServiceVerticles() {
        return super.postRegisterServiceVerticles().compose(ok -> {
            this.healthCheckProviders.forEach(arg_0 -> ((Application)this).registerHealthchecks(arg_0));
            return Future.succeededFuture();
        });
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }
}

