/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.service.management.device.Filter;
import org.eclipse.hono.service.management.device.Sort;

public final class MongoDbDocumentBuilder {
    private static final JsonPointer FIELD_ID = JsonPointer.from((String)"/id");
    private static final String TENANT_TRUSTED_CA_SUBJECT_PATH = String.format("%s.%s.%s", "tenant", "trusted-ca", "subject-dn");
    private static final String MONGODB_OPERATOR_ELEM_MATCH = "$elemMatch";
    private final JsonObject document = new JsonObject();

    private MongoDbDocumentBuilder() {
    }

    public static MongoDbDocumentBuilder builder() {
        return new MongoDbDocumentBuilder();
    }

    public MongoDbDocumentBuilder withTenantId(String tenantId) {
        this.document.put("tenant-id", tenantId);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceId(String deviceId) {
        this.document.put("device-id", deviceId);
        return this;
    }

    public MongoDbDocumentBuilder withCa(String subjectDn) {
        this.document.put(TENANT_TRUSTED_CA_SUBJECT_PATH, new JsonObject().put("$eq", subjectDn));
        return this;
    }

    public MongoDbDocumentBuilder withVersion(Optional<String> version) {
        Objects.requireNonNull(version);
        version.ifPresent(ver -> this.document.put("version", ver));
        return this;
    }

    public JsonObject document() {
        return this.document;
    }

    public MongoDbDocumentBuilder withType(String type) {
        return this.withCredentialsPredicate("type", type);
    }

    public MongoDbDocumentBuilder withAuthId(String authId) {
        return this.withCredentialsPredicate("auth-id", authId);
    }

    private MongoDbDocumentBuilder withCredentialsPredicate(String field, String value) {
        JsonObject credentialsArraySpec = this.document.getJsonObject("credentials", new JsonObject());
        JsonObject elementMatchSpec = credentialsArraySpec.getJsonObject(MONGODB_OPERATOR_ELEM_MATCH, new JsonObject());
        elementMatchSpec.put(field, value);
        credentialsArraySpec.put(MONGODB_OPERATOR_ELEM_MATCH, elementMatchSpec);
        this.document.put("credentials", credentialsArraySpec);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceFilters(List<Filter> filters) {
        filters.forEach(filter -> this.document.put(MongoDbDocumentBuilder.mapDeviceField(filter.getField()), filter.getValue()));
        return this;
    }

    public MongoDbDocumentBuilder withDeviceSortOptions(List<Sort> sortOptions) {
        sortOptions.forEach(sortOption -> this.document.put(MongoDbDocumentBuilder.mapDeviceField(sortOption.getField()), Integer.valueOf(MongoDbDocumentBuilder.mapSortingDirection(sortOption.getDirection()))));
        return this;
    }

    private static String mapDeviceField(JsonPointer field) {
        if (FIELD_ID.equals(field)) {
            return "device-id";
        }
        return "device" + field.toString().replace("/", ".");
    }

    private static int mapSortingDirection(Sort.Direction direction) {
        if (direction == Sort.Direction.asc) {
            return 1;
        }
        return -1;
    }
}

