/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.model.BaseDto;
import org.eclipse.hono.service.management.credentials.CommonCredential;

public final class CredentialsDto
extends BaseDto {
    @JsonProperty(value="tenant-id", required=true)
    private String tenantId;
    @JsonProperty(value="device-id", required=true)
    private String deviceId;
    @JsonProperty(value="credentials", required=true)
    private List<CommonCredential> credentials;
    private boolean requiresMerging;

    public CredentialsDto() {
    }

    public CredentialsDto(String tenantId, String deviceId, List<CommonCredential> credentials, String version) {
        this.setTenantId(tenantId);
        this.setDeviceId(deviceId);
        Optional.ofNullable(credentials).ifPresent(creds -> this.assertSecretIdUniqueness((List<? extends CommonCredential>)creds));
        this.setCredentials(credentials);
        this.setVersion(version);
        this.setUpdatedOn(Instant.now());
    }

    @JsonIgnore
    private void assertSecretIdUniqueness(List<? extends CommonCredential> credentials) {
        credentials.stream().map(CommonCredential::getSecrets).forEach(secrets -> {
            HashSet secretIds = new HashSet();
            AtomicInteger count = new AtomicInteger(0);
            secrets.stream().forEach(secret -> {
                if (secret.getId() != null) {
                    this.requiresMerging = true;
                    secretIds.add(secret.getId());
                    count.incrementAndGet();
                }
            });
            if (secretIds.size() < count.get()) {
                throw new ClientErrorException(400, "secret IDs must be unique within each credentials object");
            }
        });
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Objects.requireNonNull(tenantId);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = Objects.requireNonNull(deviceId);
    }

    public List<CommonCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<CommonCredential> credentials) {
        this.credentials = credentials;
    }

    @JsonIgnore
    public boolean requiresMerging() {
        return this.requiresMerging;
    }

    public void createMissingSecretIds() {
        Optional.ofNullable(this.credentials).ifPresent(creds -> creds.stream().forEach(CommonCredential::createMissingSecretIds));
    }

    @JsonIgnore
    public CredentialsDto merge(CredentialsDto otherCredentialsDto) {
        Objects.requireNonNull(otherCredentialsDto);
        Optional.ofNullable(otherCredentialsDto.getCredentials()).ifPresent(credentialsToMerge -> this.credentials.forEach(credential -> CredentialsDto.findCredentialByIdAndType(credential.getAuthId(), credential.getType(), credentialsToMerge).ifPresent(arg_0 -> ((CommonCredential)credential).merge(arg_0))));
        return this;
    }

    @JsonIgnore
    private static Optional<CommonCredential> findCredentialByIdAndType(String authId, String authType, List<CommonCredential> credentials) {
        return credentials.stream().filter(credential -> authId.equals(credential.getAuthId()) && authType.equals(credential.getType())).findFirst();
    }
}

