/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import io.opentracing.Span;
import io.vertx.core.Future;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.mongodb.config.AbstractMongoDbBasedRegistryConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.BaseDto;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbDeviceRegistryUtils {
    public static final String FIELD_CREDENTIALS = "credentials";
    public static final String FIELD_DEVICE = "device";
    public static final String FIELD_UPDATED_ON = "updatedOn";
    public static final String FIELD_VERSION = "version";
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbDeviceRegistryUtils.class);

    private MongoDbDeviceRegistryUtils() {
    }

    public static Future<Void> isModificationEnabled(AbstractMongoDbBasedRegistryConfigProperties config) {
        Objects.requireNonNull(config);
        if (config.isModificationEnabled()) {
            return Future.succeededFuture();
        }
        return Future.failedFuture((Throwable)new ClientErrorException(403, "modification is disabled"));
    }

    public static <T> OperationResult<T> mapErrorToResult(Throwable error, Span span) {
        Objects.requireNonNull(error);
        LOG.debug(error.getMessage(), error);
        TracingHelper.logError((Span)span, (String)error.getMessage(), (Throwable)error);
        if (error instanceof IllegalArgumentException) {
            return OperationResult.empty((int)400);
        }
        return OperationResult.empty((int)ServiceInvocationException.extractStatusCode((Throwable)error));
    }

    public static <T> Future<T> checkForVersionMismatchAndFail(String resourceId, Optional<String> versionFromRequest, Future<? extends BaseDto> resourceSupplierFuture) {
        Objects.requireNonNull(resourceId);
        Objects.requireNonNull(versionFromRequest);
        Objects.requireNonNull(resourceSupplierFuture);
        if (versionFromRequest.isPresent()) {
            return resourceSupplierFuture.compose(foundResource -> {
                if (!foundResource.getVersion().equals(versionFromRequest.get())) {
                    return Future.failedFuture((Throwable)new ClientErrorException(412, "Resource version mismatch"));
                }
                return Future.failedFuture((Throwable)new ServerErrorException(500, String.format("Error modifying resource [%s].", resourceId)));
            });
        }
        return Future.failedFuture((Throwable)new ClientErrorException(404, String.format("Resource [%s] not found.", resourceId)));
    }

    public static boolean isDuplicateKeyError(Throwable error) {
        Objects.requireNonNull(error);
        if (error instanceof MongoException) {
            MongoException mongoException = (MongoException)error;
            return ErrorCategory.fromErrorCode((int)mongoException.getCode()) == ErrorCategory.DUPLICATE_KEY;
        }
        return false;
    }
}

