/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.deviceregistry.mongodb.config.AbstractMongoDbBasedRegistryConfigProperties;

public final class MongoDbBasedCredentialsConfigProperties
extends AbstractMongoDbBasedRegistryConfigProperties {
    private static final String DEFAULT_CREDENTIALS_COLLECTION_NAME = "credentials";
    private final Set<String> hashAlgorithmsWhitelist = new HashSet<String>();
    private int maxBcryptIterations = 10;

    @Override
    protected String getDefaultCollectionName() {
        return DEFAULT_CREDENTIALS_COLLECTION_NAME;
    }

    public int getMaxBcryptIterations() {
        return this.maxBcryptIterations;
    }

    public void setMaxBcryptIterations(int iterations) {
        if (iterations < 4 || iterations > 31) {
            throw new IllegalArgumentException("iterations must be > 3 and < 32");
        }
        this.maxBcryptIterations = iterations;
    }

    public Set<String> getHashAlgorithmsWhitelist() {
        return Collections.unmodifiableSet(this.hashAlgorithmsWhitelist);
    }

    public void setHashAlgorithmsWhitelist(String[] hashAlgorithmsWhitelist) {
        Objects.requireNonNull(hashAlgorithmsWhitelist);
        this.hashAlgorithmsWhitelist.clear();
        this.hashAlgorithmsWhitelist.addAll(Arrays.asList(hashAlgorithmsWhitelist));
    }
}

