/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDto;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbCallExecutor;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.service.device.AbstractRegistrationService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.service.tenant.TenantInformationService;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.Lifecycle;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.service.management.device.DeviceWithId;
import org.eclipse.hono.service.management.device.Filter;
import org.eclipse.hono.service.management.device.SearchDevicesResult;
import org.eclipse.hono.service.management.device.Sort;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.RegistrationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedRegistrationService
extends AbstractRegistrationService
implements DeviceManagementService,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedRegistrationService.class);
    private static final String PROPERTY_DEVICE_MEMBER_OF = String.format("%s.%s", "device", "memberOf");
    private static final int INDEX_CREATION_MAX_RETRIES = 3;
    private static final String FIELD_SEARCH_DEVICES_COUNT = "count";
    private static final String FIELD_SEARCH_DEVICES_TOTAL_COUNT = String.format("$%s.%s", "total", "count");
    private final MongoClient mongoClient;
    private final MongoDbBasedRegistrationConfigProperties config;
    private final MongoDbCallExecutor mongoDbCallExecutor;

    public MongoDbBasedRegistrationService(Vertx vertx, MongoClient mongoClient, MongoDbBasedRegistrationConfigProperties config, TenantInformationService tenantInformationService) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(config);
        Objects.requireNonNull(tenantInformationService);
        this.mongoClient = mongoClient;
        this.mongoDbCallExecutor = new MongoDbCallExecutor(vertx, mongoClient);
        this.config = config;
    }

    public Future<Void> start() {
        Promise startPromise = Promise.promise();
        this.mongoDbCallExecutor.createCollectionIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)).put("device-id", Integer.valueOf(1)), new IndexOptions().unique(true), 3).onComplete((Handler)startPromise);
        return startPromise.future();
    }

    public Future<Void> stop() {
        this.mongoClient.close();
        return Future.succeededFuture();
    }

    public Future<OperationResult<Id>> createDevice(String tenantId, Optional<String> deviceId, Device device, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.tenantExists(tenantId, span)).compose(ok -> this.isMaxDevicesLimitReached(tenantId)).compose(ok -> this.processCreateDevice(new DeviceDto(tenantId, deviceId.orElse(DeviceRegistryUtils.getUniqueIdentifier()), device, new Versioned((Object)device).getVersion()), span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<OperationResult<Device>> readDevice(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return this.tenantExists(tenantId, span).compose(ok -> this.processReadDevice(tenantId, deviceId)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<OperationResult<SearchDevicesResult>> searchDevices(String tenantId, int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(filters);
        Objects.requireNonNull(sortOptions);
        Objects.requireNonNull(span);
        return this.tenantExists(tenantId, span).compose(ok -> this.processSearchDevices(tenantId, pageSize, pageOffset, filters, sortOptions)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<OperationResult<Id>> updateDevice(String tenantId, String deviceId, Device device, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.tenantExists(tenantId, span)).compose(deviceDto -> this.processUpdateDevice(tenantId, deviceId, device, resourceVersion, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<Result<Void>> deleteDevice(String tenantId, String deviceId, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.tenantExists(tenantId, span)).compose(ok -> this.processDeleteDevice(tenantId, deviceId, resourceVersion, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    protected Future<RegistrationResult> processAssertRegistration(DeviceKey deviceKey, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(span);
        return this.findDeviceDocument(deviceKey.getTenantId(), deviceKey.getDeviceId()).map(result -> Optional.ofNullable(result).map(ok -> this.getRegistrationResult(deviceKey.getDeviceId(), result.getJsonObject("device"))).orElse(RegistrationResult.from((int)404)));
    }

    protected Future<JsonArray> resolveGroupMembers(String tenantId, JsonArray viaGroups, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(viaGroups);
        Objects.requireNonNull(span);
        return this.processResolveGroupMembers(tenantId, viaGroups, span);
    }

    private Future<DeviceDto> findDevice(String tenantId, String deviceId) {
        return this.findDeviceDocument(tenantId, deviceId).compose(result -> Optional.ofNullable(result).map(ok -> (DeviceDto)result.mapTo(DeviceDto.class)).map(Future::succeededFuture).orElseGet(() -> Future.failedFuture((Throwable)new ClientErrorException(404))));
    }

    private Future<JsonObject> findDeviceDocument(String tenantId, String deviceId) {
        JsonObject findDeviceQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise readDevicePromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findDeviceQuery, null, (Handler)readDevicePromise);
        return readDevicePromise.future();
    }

    private RegistrationResult getRegistrationResult(String deviceId, JsonObject devicePayload) {
        return RegistrationResult.from((int)200, (JsonObject)Optional.ofNullable(devicePayload).map(ok -> new JsonObject().put("device-id", deviceId).put("data", devicePayload)).orElse(null));
    }

    private Future<OperationResult<Id>> processCreateDevice(DeviceDto device, Span span) {
        TracingHelper.TAG_DEVICE_ID.set(span, device.getDeviceId());
        Promise addDevicePromise = Promise.promise();
        this.mongoClient.insert(this.config.getCollectionName(), JsonObject.mapFrom((Object)device), (Handler)addDevicePromise);
        return addDevicePromise.future().map(success -> {
            span.log("successfully registered device");
            return OperationResult.ok((int)201, (Object)Id.of((String)device.getDeviceId()), Optional.empty(), Optional.of(device.getVersion()));
        }).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("device [{}] already exists for tenant [{}]", new Object[]{device.getDeviceId(), device.getTenantId(), error});
                TracingHelper.logError((Span)span, (String)"device already exists");
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            LOG.error("error adding device [{}] for tenant [{}]", new Object[]{device.getDeviceId(), device.getTenantId(), error});
            TracingHelper.logError((Span)span, (String)"error adding device", (Throwable)error);
            return Future.succeededFuture((Object)OperationResult.empty((int)500));
        });
    }

    private Future<Result<Void>> processDeleteDevice(String tenantId, String deviceId, Optional<String> resourceVersion, Span span) {
        JsonObject deleteDeviceQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise deleteDevicePromise = Promise.promise();
        this.mongoClient.findOneAndDelete(this.config.getCollectionName(), deleteDeviceQuery, (Handler)deleteDevicePromise);
        return deleteDevicePromise.future().compose(result -> Optional.ofNullable(result).map(deleted -> {
            span.log("successfully deleted device");
            return Future.succeededFuture((Object)Result.from((int)204));
        }).orElse(MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceId, resourceVersion, this.findDevice(tenantId, deviceId))));
    }

    private Future<OperationResult<Device>> processReadDevice(String tenantId, String deviceId) {
        return this.findDevice(tenantId, deviceId).compose(deviceDto -> Future.succeededFuture((Object)OperationResult.ok((int)200, (Object)deviceDto.getDevice(), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((int)this.config.getCacheMaxAge())), Optional.ofNullable(deviceDto.getVersion()))));
    }

    private Future<JsonArray> processResolveGroupMembers(String tenantId, JsonArray viaGroups, Span span) {
        JsonObject resolveGroupMembersQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).document().put(PROPERTY_DEVICE_MEMBER_OF, new JsonObject().put("$exists", Boolean.valueOf(true)).put("$in", viaGroups));
        FindOptions findOptionsForDeviceId = new FindOptions().setFields(new JsonObject().put("device-id", Boolean.valueOf(true)).put("_id", Boolean.valueOf(false)));
        Promise resolveGroupMembersPromise = Promise.promise();
        this.mongoClient.findWithOptions(this.config.getCollectionName(), resolveGroupMembersQuery, findOptionsForDeviceId, (Handler)resolveGroupMembersPromise);
        return resolveGroupMembersPromise.future().map(deviceIdsList -> {
            JsonArray deviceIds = Optional.ofNullable(deviceIdsList).map(ok -> deviceIdsList.stream().map(json -> json.getString("device-id")).collect(Collectors.collectingAndThen(Collectors.toList(), JsonArray::new))).orElse(new JsonArray());
            span.log("successfully resolved group members");
            return deviceIds;
        });
    }

    private Future<OperationResult<SearchDevicesResult>> processSearchDevices(String tenantId, int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions) {
        Promise searchDevicesPromise = Promise.promise();
        JsonArray searchDevicesAggregatePipelineQuery = MongoDbBasedRegistrationService.getSearchDevicesAggregatePipelineQuery(tenantId, pageSize, pageOffset, filters, sortOptions);
        if (LOG.isTraceEnabled()) {
            LOG.trace("search devices aggregate pipeline query: [{}]", (Object)searchDevicesAggregatePipelineQuery.encodePrettily());
        }
        this.mongoClient.aggregate(this.config.getCollectionName(), searchDevicesAggregatePipelineQuery).exceptionHandler(arg_0 -> ((Promise)searchDevicesPromise).fail(arg_0)).handler(arg_0 -> ((Promise)searchDevicesPromise).complete(arg_0));
        return searchDevicesPromise.future().map(result -> {
            Integer total = Optional.ofNullable(result.getInteger("total")).filter(value -> value > 0).orElseThrow(() -> new ClientErrorException(404));
            return OperationResult.ok((int)200, (Object)new SearchDevicesResult(total.intValue(), MongoDbBasedRegistrationService.getDevicesWithId(result)), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((int)this.config.getCacheMaxAge())), Optional.empty());
        });
    }

    private static List<DeviceWithId> getDevicesWithId(JsonObject searchDevicesResult) {
        return Optional.ofNullable(searchDevicesResult.getJsonArray("result")).map(devices -> devices.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(json -> (DeviceDto)json.mapTo(DeviceDto.class)).map(deviceDto -> DeviceWithId.from((String)deviceDto.getDeviceId(), (Device)deviceDto.getDevice())).collect(Collectors.toList())).orElse(new ArrayList());
    }

    private static JsonArray getSearchDevicesAggregatePipelineQuery(String tenantId, int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions) {
        JsonArray searchDevicesAggregationPipeline = new JsonArray();
        if (!filters.isEmpty()) {
            JsonObject matchDocument = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceFilters(filters).document();
            searchDevicesAggregationPipeline.add(new JsonObject().put("$match", matchDocument));
        }
        if (!sortOptions.isEmpty()) {
            JsonObject sortDocument = MongoDbDocumentBuilder.builder().withDeviceSortOptions(sortOptions).document();
            searchDevicesAggregationPipeline.add(new JsonObject().put("$sort", sortDocument));
        }
        JsonObject facetDocument = new JsonObject().put("total", new JsonArray().add(new JsonObject().put("$count", FIELD_SEARCH_DEVICES_COUNT))).put("result", new JsonArray().add(new JsonObject().put("$skip", Integer.valueOf(pageOffset * pageSize))).add(new JsonObject().put("$limit", Integer.valueOf(pageSize))));
        searchDevicesAggregationPipeline.add(new JsonObject().put("$facet", facetDocument));
        JsonObject projectDocument = new JsonObject().put("total", new JsonObject().put("$arrayElemAt", new JsonArray().add(FIELD_SEARCH_DEVICES_TOTAL_COUNT).add(Integer.valueOf(0)))).put("result", Integer.valueOf(1));
        searchDevicesAggregationPipeline.add(new JsonObject().put("$project", projectDocument));
        return searchDevicesAggregationPipeline;
    }

    private Future<OperationResult<Id>> processUpdateDevice(String tenantId, String deviceId, Device device, Optional<String> resourceVersion, Span span) {
        JsonObject updateDeviceQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise updateDevicePromise = Promise.promise();
        this.mongoClient.findOneAndReplaceWithOptions(this.config.getCollectionName(), updateDeviceQuery, JsonObject.mapFrom((Object)new DeviceDto(tenantId, deviceId, device, new Versioned((Object)device).getVersion())), new FindOptions(), new UpdateOptions().setReturningNewDocument(true), (Handler)updateDevicePromise);
        return updateDevicePromise.future().compose(result -> Optional.ofNullable(result).map(updated -> {
            span.log("successfully updated device");
            return Future.succeededFuture((Object)OperationResult.ok((int)204, (Object)Id.of((String)deviceId), Optional.empty(), Optional.of(result.getString("version"))));
        }).orElse(MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceId, resourceVersion, this.findDevice(tenantId, deviceId))));
    }

    private <T> Future<T> isMaxDevicesLimitReached(String tenantId) {
        if (this.config.getMaxDevicesPerTenant() == -1) {
            return Future.succeededFuture();
        }
        Promise findExistingNoOfDevicesPromise = Promise.promise();
        this.mongoClient.count(this.config.getCollectionName(), MongoDbDocumentBuilder.builder().withTenantId(tenantId).document(), (Handler)findExistingNoOfDevicesPromise);
        return findExistingNoOfDevicesPromise.future().compose(existingNoOfDevices -> {
            if (existingNoOfDevices >= (long)this.config.getMaxDevicesPerTenant()) {
                return Future.failedFuture((Throwable)new ClientErrorException(403, String.format("Maximum number of devices limit already reached for the tenant [%s]", tenantId)));
            }
            return Future.succeededFuture();
        });
    }

    private Future<Void> tenantExists(String tenantId, Span span) {
        return this.tenantInformationService.tenantExists(tenantId, span).compose(result -> result.isOk() ? Future.succeededFuture() : Future.failedFuture((Throwable)StatusCodeMapper.from((int)result.getStatus(), null)));
    }
}

