/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;

public final class MongoDbDocumentBuilder {
    private static final String FIELD_CREDENTIALS_AUTH_ID_KEY = String.format("%s.%s", "credentials", "auth-id");
    private static final String FIELD_CREDENTIALS_TYPE_KEY = String.format("%s.%s", "credentials", "type");
    private static final String TENANT_TRUSTED_CA_SUBJECT_PATH = String.format("%s.%s.%s", "tenant", "trusted-ca", "subject-dn");
    private final JsonObject document = new JsonObject();

    private MongoDbDocumentBuilder() {
    }

    public static MongoDbDocumentBuilder builder() {
        return new MongoDbDocumentBuilder();
    }

    public MongoDbDocumentBuilder withTenantId(String tenantId) {
        this.document.put("tenant-id", tenantId);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceId(String deviceId) {
        this.document.put("device-id", deviceId);
        return this;
    }

    public MongoDbDocumentBuilder withCa(String subjectDn) {
        this.document.put(TENANT_TRUSTED_CA_SUBJECT_PATH, new JsonObject().put("$eq", subjectDn));
        return this;
    }

    public MongoDbDocumentBuilder withVersion(Optional<String> version) {
        Objects.requireNonNull(version);
        version.ifPresent(ver -> this.document.put("version", ver));
        return this;
    }

    public JsonObject document() {
        return this.document;
    }

    public MongoDbDocumentBuilder withType(String type) {
        this.document.put(FIELD_CREDENTIALS_TYPE_KEY, type);
        return this;
    }

    public MongoDbDocumentBuilder withAuthId(String authId) {
        this.document.put(FIELD_CREDENTIALS_AUTH_ID_KEY, authId);
        return this;
    }
}

