/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDto;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbCallExecutor;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.service.credentials.AbstractCredentialsManagementService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.Lifecycle;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.CredentialsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedCredentialsService
extends AbstractCredentialsManagementService
implements CredentialsService,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedCredentialsService.class);
    private static final String CREDENTIALS_FILTERED_POSITIONAL_OPERATOR = String.format("%s.$", "credentials");
    private static final int INDEX_CREATION_MAX_RETRIES = 3;
    private final HonoPasswordEncoder passwordEncoder;
    private final MongoDbBasedCredentialsConfigProperties config;
    private final MongoClient mongoClient;
    private final MongoDbCallExecutor mongoDbCallExecutor;

    public MongoDbBasedCredentialsService(Vertx vertx, MongoClient mongoClient, MongoDbBasedCredentialsConfigProperties config, HonoPasswordEncoder passwordEncoder) {
        super(Objects.requireNonNull(vertx), Objects.requireNonNull(passwordEncoder));
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(config);
        this.mongoClient = mongoClient;
        this.config = config;
        this.passwordEncoder = passwordEncoder;
        this.mongoDbCallExecutor = new MongoDbCallExecutor(vertx, mongoClient);
    }

    public Future<Void> start() {
        return this.createIndices().map(ok -> {
            LOG.debug("MongoDB credentials service started");
            return null;
        });
    }

    public Future<Void> stop() {
        this.mongoClient.close();
        return Future.succeededFuture();
    }

    public Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(type);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(span);
        return this.processGetCredential(tenantId, type, authId, null);
    }

    public Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, JsonObject clientContext, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(type);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(clientContext);
        Objects.requireNonNull(span);
        return this.processGetCredential(tenantId, type, authId, clientContext);
    }

    protected Future<OperationResult<Void>> processUpdateCredentials(DeviceKey deviceKey, Optional<String> resourceVersion, List<CommonCredential> updatedCredentials, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceKey.getDeviceId());
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> {
            CredentialsDto updatedCredentialsDto = new CredentialsDto(deviceKey.getTenantId(), deviceKey.getDeviceId(), updatedCredentials, DeviceRegistryUtils.getUniqueIdentifier());
            if (updatedCredentialsDto.requiresMerging()) {
                return this.getCredentialsDto(deviceKey, resourceVersion).map(updatedCredentialsDto::merge);
            }
            return Future.succeededFuture((Object)updatedCredentialsDto);
        }).compose(credentialsDto -> this.updateCredentials(deviceKey, resourceVersion, JsonObject.mapFrom((Object)credentialsDto), span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    protected Future<OperationResult<List<CommonCredential>>> processReadCredentials(DeviceKey deviceKey, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(span);
        return this.getCredentialsDto(deviceKey).map(credentialsDto -> {
            List credentials = credentialsDto.getCredentials().stream().map(CommonCredential::stripPrivateInfo).collect(Collectors.toList());
            return OperationResult.ok((int)200, credentials, Optional.empty(), Optional.of(credentialsDto.getVersion()));
        }).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    protected List<CommonCredential> checkCredentials(List<CommonCredential> credentials) {
        for (CommonCredential credential : credentials) {
            DeviceRegistryUtils.checkCredential((CommonCredential)credential, (HonoPasswordEncoder)this.passwordEncoder, this.config.getHashAlgorithmsWhitelist(), (int)this.config.getMaxBcryptIterations());
        }
        return credentials;
    }

    public Future<Result<Void>> addCredentials(String tenantId, String deviceId, List<CommonCredential> credentials, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(credentials);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        return this.processAddCredentials(tenantId, deviceId, credentials, resourceVersion, span).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<Result<Void>> removeCredentials(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        return this.processRemoveCredentials(tenantId, deviceId, span).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    private CompositeFuture createIndices() {
        String authIdKey = String.format("%s.%s", "credentials", "auth-id");
        String credentialsTypeKey = String.format("%s.%s", "credentials", "type");
        return CompositeFuture.all(this.mongoDbCallExecutor.createCollectionIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)).put("device-id", Integer.valueOf(1)), new IndexOptions().unique(true), 3), this.mongoDbCallExecutor.createCollectionIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)).put(authIdKey, Integer.valueOf(1)).put(credentialsTypeKey, Integer.valueOf(1)), new IndexOptions().unique(true).partialFilterExpression(new JsonObject().put(authIdKey, new JsonObject().put("$exists", Boolean.valueOf(true))).put(credentialsTypeKey, new JsonObject().put("$exists", Boolean.valueOf(true)))), 3));
    }

    private Future<CredentialsDto> getCredentialsDto(DeviceKey deviceKey) {
        return this.getCredentialsDto(deviceKey, Optional.empty());
    }

    private Future<CredentialsDto> getCredentialsDto(DeviceKey deviceKey, Optional<String> resourceVersion) {
        JsonObject findCredentialsQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(deviceKey.getTenantId()).withDeviceId(deviceKey.getDeviceId()).document();
        Promise findCredentialsPromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findCredentialsQuery, null, (Handler)findCredentialsPromise);
        return findCredentialsPromise.future().compose(result -> Optional.ofNullable(result).map(credentialsDtoJson -> (CredentialsDto)credentialsDtoJson.mapTo(CredentialsDto.class)).map(Future::succeededFuture).orElse(MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceKey.getDeviceId(), resourceVersion, this.getCredentialsDto(deviceKey))));
    }

    private Future<CredentialsResult<JsonObject>> getCredentialsResult(String tenantId, String authId, String type) {
        JsonObject findCredentialsQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withAuthId(authId).withType(type).document();
        Promise findCredentialsPromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findCredentialsQuery, new JsonObject().put("device-id", Integer.valueOf(1)).put(CREDENTIALS_FILTERED_POSITIONAL_OPERATOR, Integer.valueOf(1)).put("_id", Integer.valueOf(0)), (Handler)findCredentialsPromise);
        return findCredentialsPromise.future().map(result -> Optional.ofNullable(result).flatMap(ok -> Optional.ofNullable(result.getJsonArray("credentials")).map(credential -> credential.getJsonObject(0)).map(credential -> credential.put("device-id", result.getString("device-id")))).filter(this::isCredentialEnabled).map(credential -> CredentialsResult.from((int)200, (Object)credential, (CacheDirective)this.getCacheDirective(type))).orElse(CredentialsResult.from((int)404)));
    }

    private CacheDirective getCacheDirective(String type) {
        if (this.config.getCacheMaxAge() > 0) {
            switch (type) {
                case "hashed-password": 
                case "x509-cert": {
                    return CacheDirective.maxAgeDirective((long)this.config.getCacheMaxAge());
                }
            }
            return CacheDirective.noCacheDirective();
        }
        return CacheDirective.noCacheDirective();
    }

    private boolean isCredentialEnabled(JsonObject credential) {
        return Optional.ofNullable(credential.getBoolean("enabled")).orElse(true);
    }

    private Future<CredentialsResult<JsonObject>> processGetCredential(String tenantId, String type, String authId, JsonObject clientContext) {
        return this.getCredentialsResult(tenantId, authId, type);
    }

    private Future<Result<Void>> processAddCredentials(String tenantId, String deviceId, List<CommonCredential> credentials, Optional<String> resourceVersion, Span span) {
        Promise addCredentialsPromise = Promise.promise();
        this.mongoClient.insert(this.config.getCollectionName(), JsonObject.mapFrom((Object)new CredentialsDto(tenantId, deviceId, credentials, resourceVersion.orElse(DeviceRegistryUtils.getUniqueIdentifier()))), (Handler)addCredentialsPromise);
        return addCredentialsPromise.future().map(added -> {
            span.log("successfully added credentials");
            LOG.debug("successfully added credentials for the device [[{}]]", (Object)deviceId);
            return Result.from((int)204);
        });
    }

    private Future<Result<Void>> processRemoveCredentials(String tenantId, String deviceId, Span span) {
        JsonObject removeCredentialsQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise removeCredentialsPromise = Promise.promise();
        this.mongoClient.findOneAndDelete(this.config.getCollectionName(), removeCredentialsQuery, (Handler)removeCredentialsPromise);
        return removeCredentialsPromise.future().compose(result -> Optional.ofNullable(result).map(removed -> {
            span.log("successfully removed credentials");
            LOG.debug("successfully removed credentials for the device [[{}]]", (Object)deviceId);
            return Future.succeededFuture((Object)Result.from((int)204));
        }).orElse(Future.failedFuture((Throwable)new ClientErrorException(404))));
    }

    private Future<OperationResult<Void>> updateCredentials(DeviceKey deviceKey, Optional<String> resourceVersion, JsonObject credentialsDtoJson, Span span) {
        JsonObject replaceCredentialsQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(deviceKey.getTenantId()).withDeviceId(deviceKey.getDeviceId()).document();
        Promise replaceCredentialsPromise = Promise.promise();
        this.mongoClient.findOneAndReplaceWithOptions(this.config.getCollectionName(), replaceCredentialsQuery, credentialsDtoJson, new FindOptions(), new UpdateOptions().setReturningNewDocument(true), (Handler)replaceCredentialsPromise);
        return replaceCredentialsPromise.future().compose(result -> {
            if (result == null) {
                return MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceKey.getDeviceId(), resourceVersion, this.getCredentialsDto(deviceKey));
            }
            LOG.debug("successfully updated credentials for device [tenant: {}, device-id: {}}]", (Object)deviceKey.getTenantId(), (Object)deviceKey.getDeviceId());
            span.log("successfully updated credentials");
            return Future.succeededFuture((Object)OperationResult.ok((int)204, (Object)null, Optional.empty(), Optional.of(result.getString("version"))));
        }).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("credentials (type, auth-id) must be unique for device [tenant: {}, device-id: {}]", new Object[]{deviceKey.getTenantId(), deviceKey.getTenantId(), error});
                TracingHelper.logError((Span)span, (String)"credentials (type, auth-id) must be unique for device");
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            return Future.failedFuture((Throwable)error);
        });
    }
}

