/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.model.BaseDto;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.credentials.CommonSecret;

public final class CredentialsDto
extends BaseDto {
    @JsonProperty(value="tenant-id", required=true)
    private String tenantId;
    @JsonProperty(value="device-id", required=true)
    private String deviceId;
    @JsonProperty(value="credentials", required=true)
    private List<CommonCredential> credentials;
    private boolean requiresMerging;

    public CredentialsDto() {
    }

    public CredentialsDto(String tenantId, String deviceId, List<CommonCredential> credentials, String version) {
        this.setTenantId(tenantId);
        this.setDeviceId(deviceId);
        Optional.ofNullable(credentials).ifPresent(creds -> {
            this.assertTypeAndAuthId((List<? extends CommonCredential>)creds);
            this.assertSecretIds((List<? extends CommonCredential>)creds);
        });
        this.setCredentials(credentials);
        this.setVersion(version);
        this.setUpdatedOn(Instant.now());
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Objects.requireNonNull(tenantId);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = Objects.requireNonNull(deviceId);
    }

    public List<CommonCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<CommonCredential> credentials) {
        this.credentials = credentials;
    }

    @JsonIgnore
    public boolean requiresMerging() {
        return this.requiresMerging;
    }

    @JsonIgnore
    public CredentialsDto merge(CredentialsDto otherCredentialsDto) {
        Objects.requireNonNull(otherCredentialsDto);
        Optional.ofNullable(otherCredentialsDto.getCredentials()).ifPresent(credentialsToMerge -> this.credentials.forEach(credential -> this.findCredentialByIdAndType(credential.getAuthId(), credential.getType(), (List<CommonCredential>)credentialsToMerge).ifPresent(arg_0 -> ((CommonCredential)credential).merge(arg_0))));
        return this;
    }

    @JsonIgnore
    private Optional<CommonCredential> findCredentialByIdAndType(String authId, String authType, List<CommonCredential> credentials) {
        return credentials.stream().filter(credential -> authId.equals(credential.getAuthId()) && authType.equals(credential.getType())).findFirst();
    }

    @JsonIgnore
    private <T extends CommonSecret> T generateSecretId(T secret) {
        if (secret.getId() == null) {
            secret.setId(DeviceRegistryUtils.getUniqueIdentifier());
        } else {
            this.requiresMerging = true;
        }
        return secret;
    }

    @JsonIgnore
    private void assertTypeAndAuthId(List<? extends CommonCredential> credentials) {
        long uniqueAuthIdAndTypeCount = credentials.stream().map(credential -> String.format("%s::%s", credential.getType(), credential.getAuthId())).distinct().count();
        if ((long)credentials.size() > uniqueAuthIdAndTypeCount) {
            throw new ClientErrorException(400, "credentials must have unique (type, auth-id)");
        }
    }

    @JsonIgnore
    private void assertSecretIds(List<? extends CommonCredential> credentials) {
        credentials.stream().map(CommonCredential::getSecrets).forEach(secrets -> {
            long uniqueIdsCount = secrets.stream().map(this::generateSecretId).map(CommonSecret::getId).distinct().count();
            if ((long)secrets.size() > uniqueIdsCount) {
                throw new ClientErrorException(400, "secret IDs must be unique within each credentials object");
            }
        });
    }
}

