/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.util.FieldLevelEncryption;
import org.eclipse.hono.service.management.BaseDto;
import org.eclipse.hono.service.management.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDbBasedDao {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedDao.class);
    private static final String FIELD_SEARCH_RESOURCES_COUNT = "count";
    private static final String FIELD_SEARCH_RESOURCES_TOTAL_COUNT = String.format("$%s.%s", "total", "count");
    protected final Tracer tracer;
    protected final MongoClient mongoClient;
    protected final String collectionName;
    protected final FieldLevelEncryption fieldLevelEncryption;

    protected MongoDbBasedDao(MongoClient mongoClient, String collectionName, Tracer tracer, FieldLevelEncryption fieldLevelEncryption) {
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(collectionName);
        this.mongoClient = mongoClient;
        this.collectionName = collectionName;
        this.tracer = Optional.ofNullable(tracer).orElse((Tracer)NoopTracerFactory.create());
        this.fieldLevelEncryption = fieldLevelEncryption;
    }

    @PreDestroy
    public final void close() {
        this.close(null);
    }

    public final void close(Handler<AsyncResult<Void>> closeHandler) {
        if (this.mongoClient != null) {
            this.mongoClient.close(ar -> {
                if (ar.succeeded()) {
                    LOG.info("successfully closed connection to Mongo DB");
                } else {
                    LOG.info("error closing connection to Mongo DB", ar.cause());
                }
                Optional.ofNullable(closeHandler).ifPresent(h -> h.handle(ar));
            });
        }
    }

    protected static boolean isDuplicateKeyError(Throwable error) {
        Objects.requireNonNull(error);
        if (error instanceof MongoException) {
            MongoException mongoException = (MongoException)error;
            return ErrorCategory.fromErrorCode((int)mongoException.getCode()) == ErrorCategory.DUPLICATE_KEY;
        }
        return false;
    }

    protected Future<Void> createIndex(JsonObject keys, IndexOptions options) {
        Objects.requireNonNull(keys);
        LOG.debug("creating index [collection: {}]", (Object)this.collectionName);
        return this.mongoClient.createIndexWithOptions(this.collectionName, keys, options).onSuccess(ok -> LOG.debug("successfully created index [collection: {}]", (Object)this.collectionName)).onFailure(t -> LOG.info("failed to create index [collection: {}]", (Object)this.collectionName, t));
    }

    protected <T> Future<SearchResult<T>> processSearchResource(int pageSize, int pageOffset, JsonObject filterDocument, JsonObject sortDocument, Function<JsonObject, List<T>> resultMapper) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("page size must be a positive integer");
        }
        if (pageOffset < 0) {
            throw new IllegalArgumentException("page offset must not be negative");
        }
        Objects.requireNonNull(filterDocument);
        Objects.requireNonNull(sortDocument);
        Objects.requireNonNull(resultMapper);
        JsonArray aggregationPipelineQuery = this.getSearchResourceQuery(pageSize, pageOffset, filterDocument, sortDocument);
        Promise searchPromise = Promise.promise();
        if (LOG.isTraceEnabled()) {
            LOG.trace("searching resources using aggregation pipeline:{}{}", (Object)System.lineSeparator(), (Object)aggregationPipelineQuery.encodePrettily());
        }
        this.mongoClient.aggregate(this.collectionName, aggregationPipelineQuery).exceptionHandler(arg_0 -> ((Promise)searchPromise).fail(arg_0)).handler(arg_0 -> ((Promise)searchPromise).complete(arg_0));
        return searchPromise.future().map(result -> Optional.ofNullable(result.getInteger("total")).filter(total -> total > 0).map(total -> new SearchResult(total.intValue(), (List)resultMapper.apply((JsonObject)result))).orElseThrow(() -> new ClientErrorException(404))).recover(this::mapError);
    }

    private JsonArray getSearchResourceQuery(int pageSize, int pageOffset, JsonObject filterDocument, JsonObject sortDocument) {
        Objects.requireNonNull(filterDocument);
        Objects.requireNonNull(sortDocument);
        JsonArray aggregationQuery = new JsonArray();
        if (!filterDocument.isEmpty()) {
            aggregationQuery.add((Object)new JsonObject().put("$match", (Object)filterDocument));
        }
        if (!sortDocument.isEmpty()) {
            aggregationQuery.add((Object)new JsonObject().put("$sort", (Object)sortDocument));
        }
        JsonObject facetDocument = new JsonObject().put("total", (Object)new JsonArray().add((Object)new JsonObject().put("$count", (Object)FIELD_SEARCH_RESOURCES_COUNT))).put("result", (Object)new JsonArray().add((Object)new JsonObject().put("$skip", (Object)(pageOffset * pageSize))).add((Object)new JsonObject().put("$limit", (Object)pageSize)));
        aggregationQuery.add((Object)new JsonObject().put("$facet", (Object)facetDocument));
        JsonObject projectDocument = new JsonObject().put("total", (Object)new JsonObject().put("$arrayElemAt", (Object)new JsonArray().add((Object)FIELD_SEARCH_RESOURCES_TOTAL_COUNT).add((Object)0))).put("result", (Object)1);
        aggregationQuery.add((Object)new JsonObject().put("$project", (Object)projectDocument));
        return aggregationQuery;
    }

    public final Future<Void> deleteAllFromCollection() {
        return this.mongoClient.removeDocuments(this.collectionName, new JsonObject()).recover(this::mapError).mapEmpty();
    }

    protected final <T> Future<T> mapError(Throwable error) {
        if (error instanceof ServiceInvocationException) {
            return Future.failedFuture((Throwable)error);
        }
        return Future.failedFuture((Throwable)new ServerErrorException(500, error));
    }

    protected static <T> Future<T> checkForVersionMismatchAndFail(String resourceId, Optional<String> versionFromRequest, Future<? extends BaseDto<?>> resourceSupplierFuture) {
        Objects.requireNonNull(resourceId);
        Objects.requireNonNull(versionFromRequest);
        Objects.requireNonNull(resourceSupplierFuture);
        if (versionFromRequest.isPresent()) {
            return resourceSupplierFuture.compose(foundResource -> {
                if (!foundResource.getVersion().equals(versionFromRequest.get())) {
                    return Future.failedFuture((Throwable)new ClientErrorException(412, "resource version mismatch"));
                }
                return Future.failedFuture((Throwable)new ServerErrorException(500, "error modifying resource"));
            });
        }
        return Future.failedFuture((Throwable)new ClientErrorException(404, "no such object"));
    }
}

