/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb;

import com.bol.config.CryptVaultAutoConfiguration;
import com.bol.crypt.CryptVault;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.mongo.HashStrategy;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.impl.DefaultHashStrategy;
import io.vertx.ext.auth.mongo.impl.MongoAuthenticationImpl;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.auth.SpringBasedHonoPasswordEncoder;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.kafka.CommonKafkaClientConfigProperties;
import org.eclipse.hono.client.kafka.producer.CachingKafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.MessagingKafkaProducerConfigProperties;
import org.eclipse.hono.client.notification.amqp.ProtonBasedNotificationSender;
import org.eclipse.hono.client.notification.kafka.KafkaBasedNotificationSender;
import org.eclipse.hono.client.notification.kafka.NotificationKafkaProducerConfigProperties;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.amqp.ProtonBasedDownstreamSender;
import org.eclipse.hono.client.telemetry.kafka.KafkaBasedEventSender;
import org.eclipse.hono.client.util.MessagingClientProvider;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoAuthProviderConfig;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedHttpServiceConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedCredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedDeviceDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedTenantDao;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsManagementService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedDeviceManagementService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedRegistrationService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedTenantManagementService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedTenantService;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryAmqpServer;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryHttpServer;
import org.eclipse.hono.deviceregistry.service.credentials.AbstractCredentialsManagementService;
import org.eclipse.hono.deviceregistry.service.device.AbstractDeviceManagementService;
import org.eclipse.hono.deviceregistry.service.device.AutoProvisionerConfigProperties;
import org.eclipse.hono.deviceregistry.service.device.EdgeDeviceAutoProvisioner;
import org.eclipse.hono.deviceregistry.service.tenant.DefaultTenantInformationService;
import org.eclipse.hono.deviceregistry.service.tenant.NoopTenantInformationService;
import org.eclipse.hono.deviceregistry.service.tenant.TenantInformationService;
import org.eclipse.hono.deviceregistry.util.CryptVaultBasedFieldLevelEncryption;
import org.eclipse.hono.deviceregistry.util.FieldLevelEncryption;
import org.eclipse.hono.deviceregistry.util.ServiceClientAdapter;
import org.eclipse.hono.notification.NotificationConstants;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationSender;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.service.credentials.DelegatingCredentialsAmqpEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.management.credentials.CredentialsManagementService;
import org.eclipse.hono.service.management.credentials.DelegatingCredentialsManagementHttpEndpoint;
import org.eclipse.hono.service.management.device.DelegatingDeviceManagementHttpEndpoint;
import org.eclipse.hono.service.management.device.DeviceAndGatewayAutoProvisioner;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.service.management.tenant.DelegatingTenantManagementHttpEndpoint;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.metric.spring.PrometheusSupport;
import org.eclipse.hono.service.registration.DelegatingRegistrationAmqpEndpoint;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.service.tenant.DelegatingTenantAmqpEndpoint;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.util.MessagingClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Configuration
@Import(value={PrometheusSupport.class})
public class ApplicationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfig.class);
    private static final String BEAN_NAME_AMQP_SERVER = "amqpServer";
    private static final String BEAN_NAME_HTTP_SERVER = "httpServer";

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    @Bean
    public Tracer tracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> commonTags() {
        return r -> r.config().commonTags((Iterable)MetricsTags.forService((String)"hono-registry"));
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.mongodb")
    public MongoDbConfigProperties mongoDbConfigProperties() {
        return new MongoDbConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public MongoClient mongoClient() {
        return MongoClient.createShared((Vertx)this.vertx(), (JsonObject)this.mongoDbConfigProperties().getMongoClientConfig());
    }

    @Bean
    public HonoPasswordEncoder passwordEncoder() {
        return new SpringBasedHonoPasswordEncoder(this.credentialsServiceProperties().getMaxBcryptCostFactor());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.registry.svc")
    public MongoDbBasedRegistrationConfigProperties registrationServiceProperties() {
        return new MongoDbBasedRegistrationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.tenant.svc")
    public MongoDbBasedTenantsConfigProperties tenantServiceProperties() {
        return new MongoDbBasedTenantsConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.credentials.svc")
    public MongoDbBasedCredentialsConfigProperties credentialsServiceProperties() {
        return new MongoDbBasedCredentialsConfigProperties();
    }

    private FieldLevelEncryption fieldLevelEncryption(String path) {
        CryptVaultBasedFieldLevelEncryption cryptVaultBasedFieldLevelEncryption;
        FileInputStream in = new FileInputStream(path);
        try {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(CryptVaultAutoConfiguration.CryptVaultConfigurationProperties.class));
            CryptVaultAutoConfiguration.CryptVaultConfigurationProperties config = (CryptVaultAutoConfiguration.CryptVaultConfigurationProperties)yaml.load((InputStream)in);
            CryptVault cryptVault = new CryptVault();
            for (CryptVaultAutoConfiguration.Key key : config.getKeys()) {
                byte[] secretKeyBytes = Base64.getDecoder().decode(key.getKey());
                cryptVault.with256BitAesCbcPkcs5PaddingAnd128BitSaltKey(key.getVersion(), secretKeyBytes);
            }
            Optional.ofNullable(config.getDefaultKey()).ifPresent(arg_0 -> ((CryptVault)cryptVault).withDefaultKeyVersion(arg_0));
            cryptVaultBasedFieldLevelEncryption = new CryptVaultBasedFieldLevelEncryption(cryptVault);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("error reading CryptVault configuration from file [%s]", path), e);
            }
        }
        in.close();
        return cryptVaultBasedFieldLevelEncryption;
    }

    @Qualifier(value="amqp")
    @Bean
    @ConfigurationProperties(prefix="hono.registry.amqp")
    public ServiceConfigProperties amqpServerProperties() {
        return new ServiceConfigProperties();
    }

    @Bean(name={"amqpServer"})
    @Scope(value="prototype")
    public DeviceRegistryAmqpServer amqpServer(TenantService tenantService, MongoDbBasedRegistrationService registrationService, MongoDbBasedCredentialsService credentialsService, TenantManagementService tenantManagementService, DeviceManagementService deviceManagementService, CredentialsManagementService credentialsManagementService) {
        DeviceRegistryAmqpServer amqpServer = new DeviceRegistryAmqpServer();
        TenantInformationService tenantInformationService = this.createAndApplyTenantInformationService(tenantManagementService, deviceManagementService, credentialsManagementService);
        MessagingClientProvider<EventSender> eventSenderProvider = this.eventSenderProvider();
        EdgeDeviceAutoProvisioner edgeDeviceAutoProvisioner = new EdgeDeviceAutoProvisioner(this.vertx(), deviceManagementService, eventSenderProvider, this.autoProvisionerConfigProperties(), this.tracer());
        registrationService.setEdgeDeviceAutoProvisioner(edgeDeviceAutoProvisioner);
        DeviceAndGatewayAutoProvisioner deviceAndGatewayAutoProvisioner = new DeviceAndGatewayAutoProvisioner(this.vertx(), deviceManagementService, credentialsManagementService, eventSenderProvider);
        credentialsService.setDeviceAndGatewayAutoProvisioner(deviceAndGatewayAutoProvisioner);
        registrationService.setTenantInformationService(tenantInformationService);
        credentialsService.setTenantInformationService(tenantInformationService);
        ArrayList<Object> endpoints = new ArrayList<Object>();
        Optional.ofNullable(tenantService).ifPresent(svc -> endpoints.add(new DelegatingTenantAmqpEndpoint(this.vertx(), svc)));
        endpoints.add(new DelegatingRegistrationAmqpEndpoint(this.vertx(), (RegistrationService)registrationService));
        endpoints.add(new DelegatingCredentialsAmqpEndpoint(this.vertx(), (CredentialsService)credentialsService));
        endpoints.forEach(ep -> {
            ep.setTracer(this.tracer());
            ep.setConfiguration((Object)this.amqpServerProperties());
            amqpServer.addEndpoint((AmqpEndpoint)ep);
        });
        return amqpServer;
    }

    private TenantInformationService createAndApplyTenantInformationService(TenantManagementService tenantManagementService, DeviceManagementService deviceManagementService, CredentialsManagementService credentialsManagementService) {
        TenantInformationService tenantInformationService = Optional.ofNullable(tenantManagementService).map(svc -> new DefaultTenantInformationService(svc)).orElseGet(NoopTenantInformationService::new);
        if (deviceManagementService instanceof AbstractDeviceManagementService) {
            ((AbstractDeviceManagementService)deviceManagementService).setTenantInformationService(tenantInformationService);
        }
        if (credentialsManagementService instanceof AbstractCredentialsManagementService) {
            ((AbstractCredentialsManagementService)credentialsManagementService).setTenantInformationService(tenantInformationService);
        }
        return tenantInformationService;
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean amqpServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_AMQP_SERVER);
        return factory;
    }

    @Bean
    @ConfigurationProperties(prefix="hono.autoprovisioning")
    public AutoProvisionerConfigProperties autoProvisionerConfigProperties() {
        return new AutoProvisionerConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public MessagingClientProvider<EventSender> eventSenderProvider() {
        MessagingClientProvider result = new MessagingClientProvider();
        if (this.downstreamSenderConfig().isHostConfigured()) {
            result.setClient((MessagingClient)new ProtonBasedDownstreamSender(HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderConfig(), (Tracer)this.tracer()), SendMessageSampler.Factory.noop(), true, true));
        }
        if (this.kafkaEventConfig().isConfigured()) {
            CachingKafkaProducerFactory factory = CachingKafkaProducerFactory.sharedFactory((Vertx)this.vertx());
            result.setClient((MessagingClient)new KafkaBasedEventSender(this.vertx(), (KafkaProducerFactory)factory, this.kafkaEventConfig(), true, this.tracer()));
        }
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)ServiceClientAdapter.forClient((ServiceClient)result));
        return result;
    }

    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties downstreamSenderConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        config.setNameIfNotSet("Device Registry");
        config.setServerRoleIfUnknown("AMQP Messaging Network");
        return config;
    }

    @ConfigurationProperties(prefix="hono.kafka")
    @Bean
    public CommonKafkaClientConfigProperties commonKafkaClientConfig() {
        return new CommonKafkaClientConfigProperties();
    }

    @ConfigurationProperties(prefix="hono.kafka.event")
    @Bean
    public MessagingKafkaProducerConfigProperties kafkaEventConfig() {
        MessagingKafkaProducerConfigProperties configProperties = new MessagingKafkaProducerConfigProperties();
        configProperties.setCommonClientConfig(this.commonKafkaClientConfig());
        return configProperties;
    }

    @Bean
    public DeviceDao deviceDao() {
        MongoDbBasedDeviceDao dao = new MongoDbBasedDeviceDao(this.mongoClient(), this.registrationServiceProperties().getCollectionName(), this.tracer());
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)dao);
        return dao;
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedRegistrationService registrationService() {
        return new MongoDbBasedRegistrationService(this.deviceDao());
    }

    @Bean
    public DeviceManagementService deviceManagementService() {
        return new MongoDbBasedDeviceManagementService(this.vertx(), this.deviceDao(), this.credentialsDao(), this.registrationServiceProperties());
    }

    @Bean
    public CredentialsDao credentialsDao() {
        MongoDbBasedCredentialsConfigProperties properties = this.credentialsServiceProperties();
        FieldLevelEncryption encryptionHelper = Optional.ofNullable(properties.getEncryptionKeyFile()).map(this::fieldLevelEncryption).orElse(FieldLevelEncryption.NOOP_ENCRYPTION);
        MongoDbBasedCredentialsDao dao = new MongoDbBasedCredentialsDao(this.mongoClient(), this.credentialsServiceProperties().getCollectionName(), this.tracer(), encryptionHelper);
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)dao);
        return dao;
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedCredentialsService credentialsService() {
        return new MongoDbBasedCredentialsService(this.credentialsDao(), this.credentialsServiceProperties());
    }

    @Bean
    public CredentialsManagementService credentialsManagementService() {
        return new MongoDbBasedCredentialsManagementService(this.vertx(), this.credentialsDao(), this.credentialsServiceProperties(), this.passwordEncoder());
    }

    @Bean
    public TenantDao tenantDao() {
        MongoDbBasedTenantDao dao = new MongoDbBasedTenantDao(this.mongoClient(), this.tenantServiceProperties().getCollectionName(), this.tracer());
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)dao);
        return dao;
    }

    @Bean
    public TenantService tenantService() {
        return new MongoDbBasedTenantService(this.tenantDao(), this.tenantServiceProperties());
    }

    @Bean
    public TenantManagementService tenantManagementService() {
        return new MongoDbBasedTenantManagementService(this.vertx(), this.tenantDao(), this.tenantServiceProperties());
    }

    @Qualifier(value="http")
    @Bean
    @ConfigurationProperties(prefix="hono.registry.http")
    public MongoDbBasedHttpServiceConfigProperties httpServerProperties() {
        return new MongoDbBasedHttpServiceConfigProperties();
    }

    @Bean(name={"httpServer"})
    @Scope(value="prototype")
    public DeviceRegistryHttpServer httpServer(TenantManagementService tenantManagementService, DeviceManagementService deviceManagementService, CredentialsManagementService credentialsManagementService) {
        DeviceRegistryHttpServer httpServer = new DeviceRegistryHttpServer();
        this.createAndApplyTenantInformationService(tenantManagementService, deviceManagementService, credentialsManagementService);
        ArrayList<Object> endpoints = new ArrayList<Object>();
        Optional.ofNullable(tenantManagementService).ifPresent(svc -> endpoints.add(new DelegatingTenantManagementHttpEndpoint(this.vertx(), svc)));
        endpoints.add(new DelegatingDeviceManagementHttpEndpoint(this.vertx(), deviceManagementService));
        endpoints.add(new DelegatingCredentialsManagementHttpEndpoint(this.vertx(), credentialsManagementService));
        endpoints.forEach(ep -> {
            ep.setTracer(this.tracer());
            ep.setConfiguration((ServiceConfigProperties)this.httpServerProperties());
            httpServer.addEndpoint((HttpEndpoint)ep);
        });
        return httpServer;
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean httpServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_HTTP_SERVER);
        return factory;
    }

    @Bean
    @Scope(value="prototype")
    public AuthenticationHandler createAuthHandler(MongoDbBasedHttpServiceConfigProperties httpServiceConfigProperties) {
        if (httpServiceConfigProperties.isAuthenticationRequired()) {
            MongoAuthProviderConfig authConfig = httpServiceConfigProperties.getAuth();
            LOG.debug("creating AuthenticationHandler guarding access to registry's HTTP endpoint using configuration:{}{}", (Object)System.lineSeparator(), (Object)authConfig);
            MongoAuthenticationOptions mongoAuthOptions = new MongoAuthenticationOptions();
            mongoAuthOptions.setCollectionName(authConfig.getCollectionName());
            mongoAuthOptions.setUsernameField(authConfig.getUsernameField());
            mongoAuthOptions.setPasswordField(authConfig.getPasswordField());
            DefaultHashStrategy hashStrategy = new DefaultHashStrategy();
            Optional.ofNullable(authConfig.getHashAlgorithm()).ifPresent(arg_0 -> ((DefaultHashStrategy)hashStrategy).setAlgorithm(arg_0));
            Optional.ofNullable(authConfig.getSaltStyle()).ifPresent(arg_0 -> ((DefaultHashStrategy)hashStrategy).setSaltStyle(arg_0));
            MongoAuthenticationImpl mongoAuth = new MongoAuthenticationImpl(this.mongoClient(), (HashStrategy)hashStrategy, authConfig.getSaltField(), mongoAuthOptions);
            return BasicAuthHandler.create((AuthenticationProvider)mongoAuth, (String)this.httpServerProperties().getRealm());
        }
        return null;
    }

    @ConfigurationProperties(prefix="hono.kafka.notification")
    @Bean
    public NotificationKafkaProducerConfigProperties notificationKafkaProducerConfig() {
        NotificationKafkaProducerConfigProperties configProperties = new NotificationKafkaProducerConfigProperties();
        configProperties.setCommonClientConfig(this.commonKafkaClientConfig());
        return configProperties;
    }

    @Bean
    public NotificationSender notificationSender() {
        NotificationKafkaProducerConfigProperties kafkaProducerConfig = this.notificationKafkaProducerConfig();
        Object notificationSender = kafkaProducerConfig.isConfigured() ? new KafkaBasedNotificationSender((KafkaProducerFactory)CachingKafkaProducerFactory.sharedFactory((Vertx)this.vertx()), kafkaProducerConfig) : new ProtonBasedNotificationSender(HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderConfig(), (Tracer)this.tracer()));
        if (notificationSender instanceof ServiceClient) {
            this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)ServiceClientAdapter.forClient((ServiceClient)((ServiceClient)notificationSender)));
        }
        NotificationConstants.DEVICE_REGISTRY_NOTIFICATION_TYPES.forEach(arg_0 -> this.lambda$notificationSender$6((NotificationSender)notificationSender, arg_0));
        return notificationSender;
    }

    private /* synthetic */ void lambda$notificationSender$6(NotificationSender notificationSender, NotificationType notificationType) {
        NotificationEventBusSupport.registerConsumer((Vertx)this.vertx(), (NotificationType)notificationType, arg_0 -> ((NotificationSender)notificationSender).publish(arg_0));
    }
}

