/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.service.tenant.AbstractTenantManagementService;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.Sort;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantDto;
import org.eclipse.hono.service.management.tenant.TenantWithId;

public final class MongoDbBasedTenantManagementService
extends AbstractTenantManagementService {
    private final TenantDao dao;
    private final MongoDbBasedTenantsConfigProperties config;

    public MongoDbBasedTenantManagementService(TenantDao tenantDao, MongoDbBasedTenantsConfigProperties config) {
        Objects.requireNonNull(tenantDao);
        Objects.requireNonNull(config);
        this.dao = tenantDao;
        this.config = config;
    }

    protected Future<OperationResult<Id>> processCreateTenant(String tenantId, Tenant tenantObj, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(tenantObj);
        Objects.requireNonNull(span);
        TenantDto tenantDto = TenantDto.forCreation((String)tenantId, (Tenant)tenantObj, (String)DeviceRegistryUtils.getUniqueIdentifier());
        return this.dao.create(tenantDto, span.context()).map(resourceVersion -> OperationResult.ok((int)201, (Object)Id.of((String)tenantId), Optional.empty(), Optional.of(resourceVersion)));
    }

    protected Future<OperationResult<Tenant>> processReadTenant(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.dao.getById(tenantId, span.context()).map(dto -> OperationResult.ok((int)200, (Object)dto.getData(), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge())), Optional.ofNullable(dto.getVersion())));
    }

    public Future<OperationResult<Void>> processUpdateTenant(String tenantId, Tenant tenantObj, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(tenantObj);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return this.dao.getById(tenantId, span.context()).map(currentTenantConfig -> (TenantDto)TenantDto.forUpdate(() -> currentTenantConfig, (Object)tenantObj, (String)DeviceRegistryUtils.getUniqueIdentifier())).compose(updatedTenantConfig -> this.dao.update((TenantDto)updatedTenantConfig, resourceVersion, span.context())).map(newVersion -> OperationResult.ok((int)204, (Object)null, Optional.empty(), Optional.of(newVersion)));
    }

    protected Future<Result<Void>> processDeleteTenant(String tenantId, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return this.dao.delete(tenantId, resourceVersion, span.context()).map(ok -> Result.from((int)204));
    }

    protected Future<OperationResult<SearchResult<TenantWithId>>> processSearchTenants(int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions, Span span) {
        Objects.requireNonNull(filters);
        Objects.requireNonNull(sortOptions);
        Objects.requireNonNull(span);
        return this.dao.find(pageSize, pageOffset, filters, sortOptions, span.context()).map(result -> OperationResult.ok((int)200, (Object)result, Optional.empty(), Optional.empty()));
    }
}

