/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.NoConsumerException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.registry.DeviceDisabledOrNotRegisteredException;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.client.registry.TenantDisabledOrNotRegisteredException;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.tracing.TenantTraceSamplingHelper;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingAndDelegatingCommandHandler
implements Lifecycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TenantClient tenantClient;
    private final CommandTargetMapper commandTargetMapper;
    private final InternalCommandSender internalCommandSender;

    public AbstractMappingAndDelegatingCommandHandler(TenantClient tenantClient, CommandTargetMapper commandTargetMapper, InternalCommandSender internalCommandSender) {
        this.tenantClient = Objects.requireNonNull(tenantClient);
        this.commandTargetMapper = Objects.requireNonNull(commandTargetMapper);
        this.internalCommandSender = Objects.requireNonNull(internalCommandSender);
    }

    public Future<Void> start() {
        return this.internalCommandSender.start();
    }

    public Future<Void> stop() {
        return this.internalCommandSender.stop();
    }

    protected abstract MessagingType getMessagingType();

    protected final Future<Void> mapAndDelegateIncomingCommand(CommandContext commandContext) {
        Command command = commandContext.getCommand();
        this.log.trace("determine command target gateway/adapter for [{}]", (Object)command);
        Future tenantObjectFuture = this.tenantClient.get(command.getTenant(), commandContext.getTracingContext());
        return tenantObjectFuture.map(tenantObject -> {
            TenantTraceSamplingHelper.applyTraceSamplingPriority((TenantObject)tenantObject, null, (Span)commandContext.getTracingSpan());
            return tenantObject;
        }).compose(tenantObject -> {
            MessagingType tenantMessagingType = Optional.ofNullable((JsonObject)tenantObject.getProperty("ext", JsonObject.class)).map(ext -> ext.getString("messaging-type")).map(MessagingType::valueOf).orElse(null);
            if (tenantMessagingType != null && this.getMessagingType() != tenantMessagingType) {
                this.log.info("command received via {} but tenant is configured to use {} [{}]", new Object[]{this.getMessagingType(), tenantMessagingType, commandContext.getCommand()});
                commandContext.getTracingSpan().log(String.format("command received via %s but tenant is configured to use %s", this.getMessagingType(), tenantMessagingType));
            }
            return this.commandTargetMapper.getTargetGatewayAndAdapterInstance(command.getTenant(), command.getDeviceId(), commandContext.getTracingContext());
        }).recover(cause -> {
            Throwable error;
            if (tenantObjectFuture.failed() && ServiceInvocationException.extractStatusCode((Throwable)cause) == 404) {
                error = new TenantDisabledOrNotRegisteredException(command.getTenant(), 404);
            } else if (cause instanceof DeviceDisabledOrNotRegisteredException) {
                error = cause;
            } else if (ServiceInvocationException.extractStatusCode((Throwable)cause) == 404) {
                this.log.debug("no target adapter instance found for command with device id " + command.getDeviceId(), cause);
                error = new NoConsumerException("no target adapter instance found");
            } else {
                this.log.debug("error getting target gateway and adapter instance for command with device id " + command.getDeviceId(), cause);
                error = new ServerErrorException(503, "error getting target gateway and adapter instance", cause);
            }
            if (error instanceof ClientErrorException) {
                commandContext.reject(error);
            } else {
                commandContext.release(error);
            }
            return Future.failedFuture((Throwable)cause);
        }).compose(result -> {
            String targetGatewayId;
            String targetAdapterInstanceId = result.getString("adapter-instance-id");
            String targetDeviceId = result.getString("device-id");
            String string = targetGatewayId = targetDeviceId.equals(command.getDeviceId()) ? null : targetDeviceId;
            if (Objects.isNull(targetGatewayId)) {
                this.log.trace("determined target adapter instance [{}] for [{}] (command not mapped to gateway)", (Object)targetAdapterInstanceId, (Object)command);
            } else {
                command.setGatewayId(targetGatewayId);
                this.log.trace("determined target gateway [{}] and adapter instance [{}] for [{}]", new Object[]{targetGatewayId, targetAdapterInstanceId, command});
                commandContext.getTracingSpan().log("determined target gateway [" + targetGatewayId + "]");
            }
            return this.sendCommand(commandContext, targetAdapterInstanceId);
        });
    }

    protected Future<Void> sendCommand(CommandContext commandContext, String targetAdapterInstanceId) {
        return this.internalCommandSender.sendCommand(commandContext, targetAdapterInstanceId);
    }
}

