/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.kafka;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.adapter.client.command.CommandContext;
import org.eclipse.hono.adapter.client.command.InternalCommandSender;
import org.eclipse.hono.adapter.client.command.kafka.KafkaBasedCommand;
import org.eclipse.hono.adapter.client.command.kafka.KafkaBasedCommandContext;
import org.eclipse.hono.adapter.client.command.kafka.KafkaBasedInternalCommandSender;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.client.impl.CommandConsumer;
import org.eclipse.hono.client.kafka.tracing.KafkaTracingHelper;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;
import org.eclipse.hono.commandrouter.impl.kafka.KafkaCommandProcessingQueue;

public class KafkaBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler {
    private final Tracer tracer;
    private final KafkaCommandProcessingQueue commandQueue;

    public KafkaBasedMappingAndDelegatingCommandHandler(TenantClient tenantClient, KafkaCommandProcessingQueue commandQueue, CommandTargetMapper commandTargetMapper, KafkaBasedInternalCommandSender internalCommandSender, Tracer tracer) {
        super(tenantClient, commandTargetMapper, (InternalCommandSender)internalCommandSender);
        this.commandQueue = Objects.requireNonNull(commandQueue);
        this.tracer = Objects.requireNonNull(tracer);
    }

    @Override
    public Future<Void> stop() {
        this.commandQueue.setCurrentlyHandledPartitions(List.of());
        return super.stop();
    }

    public Future<Void> mapAndDelegateIncomingCommandMessage(KafkaConsumerRecord<String, Buffer> consumerRecord) {
        KafkaBasedCommand command;
        Objects.requireNonNull(consumerRecord);
        try {
            command = KafkaBasedCommand.from(consumerRecord);
        }
        catch (IllegalArgumentException exception) {
            this.log.debug("command record is invalid", (Throwable)exception);
            return Future.failedFuture((String)"command record is invalid");
        }
        SpanContext spanContext = KafkaTracingHelper.extractSpanContext((Tracer)this.tracer, consumerRecord);
        Span currentSpan = CommandConsumer.createSpan((String)"map and delegate command", (String)command.getTenant(), (String)command.getDeviceId(), null, (Tracer)this.tracer, (SpanContext)spanContext);
        KafkaTracingHelper.setRecordTags((Span)currentSpan, consumerRecord);
        KafkaBasedCommandContext commandContext = new KafkaBasedCommandContext(command, currentSpan);
        command.logToSpan(currentSpan);
        if (!command.isValid()) {
            this.log.debug("received invalid command record [{}]", (Object)command);
            commandContext.reject("malformed command message");
            return Future.failedFuture((String)"command is invalid");
        }
        this.log.trace("received valid command record [{}]", (Object)command);
        this.commandQueue.add(commandContext);
        return this.mapAndDelegateIncomingCommand((CommandContext)commandContext).onFailure(thr -> this.commandQueue.remove(commandContext));
    }

    @Override
    protected Future<Void> sendCommand(CommandContext commandContext, String targetAdapterInstanceId) {
        KafkaBasedCommandContext cmdContext = (KafkaBasedCommandContext)commandContext;
        return this.commandQueue.applySendCommandAction(cmdContext, () -> super.sendCommand(commandContext, targetAdapterInstanceId));
    }
}

