/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.adapter.client.registry.DeviceRegistrationClient;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.RegistrationAssertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTargetMapperImpl
implements CommandTargetMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CommandTargetMapperImpl.class);
    private final Tracer tracer;
    private final DeviceRegistrationClient registrationClient;
    private final DeviceConnectionInfo deviceConnectionInfo;

    public CommandTargetMapperImpl(DeviceRegistrationClient registrationClient, DeviceConnectionInfo deviceConnectionInfo, Tracer tracer) {
        this.registrationClient = Objects.requireNonNull(registrationClient);
        this.deviceConnectionInfo = Objects.requireNonNull(deviceConnectionInfo);
        this.tracer = Objects.requireNonNull(tracer);
    }

    @Override
    public final Future<JsonObject> getTargetGatewayAndAdapterInstance(String tenantId, String deviceId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)context, (String)"get target gateway and adapter instance", (String)CommandTargetMapper.class.getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "consumer").withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)deviceId).start();
        return this.registrationClient.assertRegistration(tenantId, deviceId, null, span.context()).map(RegistrationAssertion::getAuthorizedGateways).recover(t -> {
            LOG.debug("Error retrieving gateways authorized to act on behalf of device [tenant-id: {}, device-id: {}]", new Object[]{tenantId, deviceId, t});
            return Future.failedFuture((Throwable)t);
        }).compose(viaGateways -> this.deviceConnectionInfo.getCommandHandlingAdapterInstances(tenantId, deviceId, new HashSet(viaGateways), span).compose(resultJson -> this.determineTargetInstanceJson((JsonObject)resultJson, deviceId, (List<String>)viaGateways, span))).onFailure(t -> {
            LOG.debug("Error getting target gateway and adapter instance", t);
            TracingHelper.logError((Span)span, (Throwable)t);
            Tags.HTTP_STATUS.set(span, Integer.valueOf(ServiceInvocationException.extractStatusCode((Throwable)t)));
        }).onComplete(ar -> span.finish());
    }

    private Future<JsonObject> determineTargetInstanceJson(JsonObject adapterInstancesJson, String deviceId, List<String> viaGateways, Span span) {
        JsonObject targetInstanceObject;
        JsonArray instancesArray = adapterInstancesJson.getJsonArray("adapter-instances");
        if (instancesArray == null || instancesArray.isEmpty()) {
            return this.createAndLogInternalServerErrorFuture(span, "Invalid result JSON; field 'adapter-instances' is null or empty");
        }
        try {
            targetInstanceObject = instancesArray.size() == 1 ? instancesArray.getJsonObject(0) : this.chooseTargetGatewayAndAdapterInstance(instancesArray);
        }
        catch (ClassCastException e) {
            return this.createAndLogInternalServerErrorFuture(span, "Invalid result JSON: " + e);
        }
        String targetDevice = targetInstanceObject.getString("device-id");
        String targetAdapterInstance = targetInstanceObject.getString("adapter-instance-id");
        if (targetDevice == null || targetAdapterInstance == null) {
            return this.createAndLogInternalServerErrorFuture(span, "Invalid result JSON, missing target device and/or adapter instance");
        }
        if (!targetDevice.equals(deviceId)) {
            if (!viaGateways.contains(targetDevice)) {
                return this.createAndLogInternalServerErrorFuture(span, "Invalid result JSON, target gateway " + targetDevice + " is not in via gateways list");
            }
            span.setTag("gateway_id", targetDevice);
        }
        String choiceInfo = instancesArray.size() > 1 ? " chosen from " + instancesArray.size() + " entries" : "";
        Object gatewayInfo = !targetDevice.equals(deviceId) ? " gateway '" + targetDevice + "' and" : "";
        String infoMsg = String.format("command target%s:%s adapter instance '%s'", choiceInfo, gatewayInfo, targetAdapterInstance);
        LOG.debug(infoMsg);
        span.log(infoMsg);
        span.setTag("adapter_instance_id", targetAdapterInstance);
        return Future.succeededFuture((Object)targetInstanceObject);
    }

    private Future<JsonObject> createAndLogInternalServerErrorFuture(Span span, String errorMessage) {
        LOG.error(errorMessage);
        TracingHelper.logError((Span)span, (String)errorMessage);
        return Future.failedFuture((Throwable)new ServerErrorException(500));
    }

    protected JsonObject chooseTargetGatewayAndAdapterInstance(JsonArray instancesArray) {
        return instancesArray.getJsonObject(0);
    }
}

