/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.kafka;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommand;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommandContext;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommandResponseSender;
import org.eclipse.hono.client.command.kafka.KafkaBasedInternalCommandSender;
import org.eclipse.hono.client.impl.CommandConsumer;
import org.eclipse.hono.client.kafka.tracing.KafkaTracingHelper;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.commandrouter.CommandRouterMetrics;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;
import org.eclipse.hono.commandrouter.impl.kafka.KafkaCommandProcessingQueue;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.TenantObject;

public class KafkaBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler {
    private final KafkaBasedCommandResponseSender kafkaBasedCommandResponseSender;
    private final Tracer tracer;
    private final KafkaCommandProcessingQueue commandQueue;

    public KafkaBasedMappingAndDelegatingCommandHandler(TenantClient tenantClient, KafkaCommandProcessingQueue commandQueue, CommandTargetMapper commandTargetMapper, KafkaBasedInternalCommandSender internalCommandSender, KafkaBasedCommandResponseSender kafkaBasedCommandResponseSender, CommandRouterMetrics metrics, Tracer tracer) {
        super(tenantClient, commandTargetMapper, (InternalCommandSender)internalCommandSender, metrics);
        this.commandQueue = Objects.requireNonNull(commandQueue);
        this.kafkaBasedCommandResponseSender = Objects.requireNonNull(kafkaBasedCommandResponseSender);
        this.tracer = Objects.requireNonNull(tracer);
    }

    @Override
    protected final MessagingType getMessagingType() {
        return MessagingType.kafka;
    }

    @Override
    public Future<Void> stop() {
        this.commandQueue.setCurrentlyHandledPartitions(List.of());
        return super.stop();
    }

    public Future<Void> mapAndDelegateIncomingCommandMessage(KafkaConsumerRecord<String, Buffer> consumerRecord) {
        KafkaBasedCommand command;
        Objects.requireNonNull(consumerRecord);
        Timer.Sample timer = this.getMetrics().startTimer();
        try {
            command = KafkaBasedCommand.from(consumerRecord);
        }
        catch (IllegalArgumentException exception) {
            this.log.debug("command record is invalid", (Throwable)exception);
            return Future.failedFuture((String)"command record is invalid");
        }
        SpanContext spanContext = KafkaTracingHelper.extractSpanContext((Tracer)this.tracer, consumerRecord);
        Span currentSpan = CommandConsumer.createSpan((String)"map and delegate command", (String)command.getTenant(), (String)command.getDeviceId(), null, (Tracer)this.tracer, (SpanContext)spanContext);
        KafkaTracingHelper.setRecordTags((Span)currentSpan, consumerRecord);
        KafkaBasedCommandContext commandContext = new KafkaBasedCommandContext(command, currentSpan, (CommandResponseSender)this.kafkaBasedCommandResponseSender);
        command.logToSpan(currentSpan);
        if (!command.isValid()) {
            this.log.debug("received invalid command record [{}]", (Object)command);
            commandContext.reject("malformed command message");
            this.reportInvalidCommand((CommandContext)commandContext, timer);
            return Future.failedFuture((String)"command is invalid");
        }
        this.log.trace("received valid command record [{}]", (Object)command);
        this.commandQueue.add(commandContext);
        return this.mapAndDelegateIncomingCommand((CommandContext)commandContext, timer).onFailure(thr -> this.commandQueue.remove(commandContext));
    }

    @Override
    protected Future<Void> sendCommand(CommandContext commandContext, String targetAdapterInstanceId, TenantObject tenantObject, Timer.Sample timer) {
        KafkaBasedCommandContext cmdContext = (KafkaBasedCommandContext)commandContext;
        return this.commandQueue.applySendCommandAction(cmdContext, () -> super.sendCommand(commandContext, targetAdapterInstanceId, tenantObject, timer));
    }
}

