/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import org.eclipse.hono.service.ApplicationOptions;

public class ApplicationConfigProperties {
    private int maxInstances = 0;
    private boolean amqpMessagingDisabled = false;
    private boolean kafkaMessagingDisabled = false;
    private boolean pubSubMessagingDisabled = false;

    public ApplicationConfigProperties() {
    }

    public ApplicationConfigProperties(ApplicationOptions options) {
        this.setMaxInstances(options.maxInstances());
        this.amqpMessagingDisabled = options.amqpMessagingDisabled();
        this.kafkaMessagingDisabled = options.kafkaMessagingDisabled();
        this.pubSubMessagingDisabled = options.pubSubMessagingDisabled();
    }

    public final int getMaxInstances() {
        if (this.maxInstances > 0 && this.maxInstances < Runtime.getRuntime().availableProcessors()) {
            return this.maxInstances;
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public final void setMaxInstances(int maxVerticleInstances) {
        if (maxVerticleInstances < 0) {
            throw new IllegalArgumentException("maxInstances must be >= 0");
        }
        this.maxInstances = maxVerticleInstances;
    }

    public final boolean isAmqpMessagingDisabled() {
        return this.amqpMessagingDisabled;
    }

    public final void setAmqpMessagingDisabled(boolean disabled) {
        this.amqpMessagingDisabled = disabled;
    }

    public final boolean isKafkaMessagingDisabled() {
        return this.kafkaMessagingDisabled;
    }

    public final void setKafkaMessagingDisabled(boolean disabled) {
        this.kafkaMessagingDisabled = disabled;
    }

    public final boolean isPubSubMessagingDisabled() {
        return this.pubSubMessagingDisabled;
    }

    public final void setPubSubMessagingDisabled(boolean disabled) {
        this.pubSubMessagingDisabled = disabled;
    }
}

