/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.opentracing.Span;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import java.util.Optional;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.http.HttpServerSpanHelper;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailureHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFailureHandler.class);
    private static final String ERROR_DETAIL_NOT_AVAILABLE = "N/A";

    public void handle(RoutingContext ctx) {
        if (ctx.failed()) {
            if (ctx.response().ended()) {
                LOG.debug("skipping processing of failed route, response already ended");
            } else {
                LOG.debug("handling failed route for request [method: {}, URI: {}, status: {}] - {}", new Object[]{ctx.request().method(), HttpUtils.getAbsoluteURI(ctx.request()), ctx.statusCode(), ctx.getBody(), ctx.failure()});
                Span span = HttpServerSpanHelper.serverSpan(ctx);
                if (ctx.failure() != null) {
                    int statusCode;
                    if (ctx.failure() instanceof ServiceInvocationException) {
                        statusCode = ((ServiceInvocationException)ctx.failure()).getErrorCode();
                    } else if (ctx.failure() instanceof HttpException) {
                        statusCode = ((HttpException)ctx.failure()).getStatusCode();
                    } else if (ctx.statusCode() >= 400 && ctx.statusCode() < 600) {
                        statusCode = ctx.statusCode();
                    } else {
                        LOG.debug("unexpected internal failure", ctx.failure());
                        statusCode = 500;
                    }
                    Optional.ofNullable(span).ifPresent(s -> this.logErrorInTraceSpan(span, ctx.failure(), statusCode));
                    this.sendError(ctx.response(), statusCode, ctx.failure().getMessage());
                } else if (ctx.statusCode() != -1) {
                    if (span != null) {
                        String message = HttpResponseStatus.valueOf((int)ctx.statusCode()).reasonPhrase();
                        TracingHelper.logError((Span)span, (String)message);
                    }
                    this.sendError(ctx.response(), ctx.statusCode(), null);
                } else {
                    Optional.ofNullable(span).ifPresent(s -> TracingHelper.logError((Span)span, (String)"unspecified error occurred"));
                    this.sendError(ctx.response(), 500, "Internal Server Error");
                }
            }
        } else {
            LOG.debug("skipping processing of non-failed route");
            ctx.next();
        }
    }

    protected Buffer createResponsePayload(String errorMessage) {
        return new JsonObject().put("error", (Object)Optional.ofNullable(errorMessage).orElse(ERROR_DETAIL_NOT_AVAILABLE)).toBuffer();
    }

    private void logErrorInTraceSpan(Span span, Throwable error, int errorCode) {
        boolean skipUnexpectedErrorCheck = errorCode >= 400 && errorCode < 500;
        TracingHelper.logError((Span)span, (Throwable)error, (boolean)skipUnexpectedErrorCheck);
    }

    private void sendError(HttpServerResponse response, int errorCode, String errorMessage) {
        response.setStatusCode(errorCode);
        HttpUtils.setResponseBody(response, this.createResponsePayload(errorMessage), "application/json; charset=utf-8");
        response.end();
    }
}

