/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.amqp;

import io.vertx.core.Vertx;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.eclipse.hono.service.AbstractEndpoint;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.util.ResourceIdentifier;

public abstract class AbstractAmqpEndpoint<T>
extends AbstractEndpoint
implements AmqpEndpoint {
    protected T config;

    protected AbstractAmqpEndpoint(Vertx vertx) {
        super(vertx);
    }

    public final void setConfiguration(T props) {
        this.config = Objects.requireNonNull(props);
    }

    protected void onLinkDetach(ProtonReceiver client) {
        this.onLinkDetach((ProtonLink<?>)client, null);
    }

    protected final void onLinkDetach(ProtonLink<?> client, ErrorCondition error) {
        if (error == null) {
            this.logger.debug("closing link [{}]", (Object)client.getName());
        } else {
            this.logger.debug("closing link [{}]: {}", (Object)client.getName(), (Object)error.getDescription());
            client.setCondition(error);
        }
        client.close();
    }

    @Override
    public void onLinkAttach(ProtonConnection con, ProtonReceiver receiver, ResourceIdentifier targetResource) {
        this.logger.info("Endpoint [{}] does not support data upload, closing link.", (Object)this.getName());
        receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_IMPLEMENTED, (String)"resource cannot be written to"));
        receiver.close();
    }

    @Override
    public void onLinkAttach(ProtonConnection con, ProtonSender sender, ResourceIdentifier targetResource) {
        this.logger.info("Endpoint [{}] does not support data retrieval, closing link.", (Object)this.getName());
        sender.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_IMPLEMENTED, (String)"resource cannot be read from"));
        sender.close();
    }
}

