/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.smallrye.health.api.HealthRegistry;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.healthchecks.CheckResult;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Deprecated
public class SmallRyeHealthCheckServer
implements HealthCheckServer {
    private static final Logger LOG = LoggerFactory.getLogger(SmallRyeHealthCheckServer.class);
    private final SmallRyeHealthAdapter readinessChecksAdapter;
    private final SmallRyeHealthAdapter livenessChecksAdapter;

    public SmallRyeHealthCheckServer(@Readiness HealthRegistry readinessCheckRegistry, @Liveness HealthRegistry livenessCheckRegistry) {
        Objects.requireNonNull(readinessCheckRegistry);
        Objects.requireNonNull(livenessCheckRegistry);
        this.readinessChecksAdapter = new SmallRyeHealthAdapter("readiness", readinessCheckRegistry);
        this.livenessChecksAdapter = new SmallRyeHealthAdapter("liveness", livenessCheckRegistry);
    }

    public Future<Void> start() {
        return Future.succeededFuture();
    }

    public Future<Void> stop() {
        return Future.succeededFuture();
    }

    @Override
    public void registerHealthCheckResources(HealthCheckProvider serviceInstance) {
        Objects.requireNonNull(serviceInstance);
        serviceInstance.registerReadinessChecks(this.readinessChecksAdapter);
        serviceInstance.registerLivenessChecks(this.livenessChecksAdapter);
    }

    private static class SmallRyeHealthAdapter
    implements HealthCheckHandler {
        private final HealthRegistry registry;
        private final String type;

        private SmallRyeHealthAdapter(String type, HealthRegistry registry) {
            this.type = Objects.requireNonNull(type);
            this.registry = Objects.requireNonNull(registry);
        }

        public void handle(RoutingContext event) {
            throw new UnsupportedOperationException();
        }

        private HealthCheckResponse getResponse(String name, Status status) {
            HealthCheckResponseBuilder builder = HealthCheckResponse.builder().name(name).status(status.isOk());
            Optional.ofNullable(status.getData()).ifPresent(json -> json.stream().forEach(entry -> {
                Object patt4856$temp = entry.getValue();
                if (patt4856$temp instanceof Boolean) {
                    Boolean v = (Boolean)patt4856$temp;
                    builder.withData((String)entry.getKey(), v.booleanValue());
                } else {
                    Object patt4989$temp = entry.getValue();
                    if (patt4989$temp instanceof String) {
                        String v = (String)patt4989$temp;
                        builder.withData((String)entry.getKey(), v);
                    } else {
                        Object patt5121$temp = entry.getValue();
                        if (patt5121$temp instanceof Number) {
                            Number v = (Number)patt5121$temp;
                            builder.withData((String)entry.getKey(), v.longValue());
                        }
                    }
                }
            }));
            return builder.build();
        }

        private HealthCheckResponse getResponse(String name, Throwable error) {
            return HealthCheckResponse.builder().name(name).down().withData("error", Optional.ofNullable(error.getMessage()).orElse(error.getClass().getName())).build();
        }

        public HealthCheckHandler register(String name, Handler<Promise<Status>> procedure) {
            LOG.debug("registering legacy {} check [name: {}]", (Object)this.type, (Object)name);
            this.registry.register(name, () -> {
                Promise result = Promise.promise();
                procedure.handle((Object)result);
                return UniHelper.toUni((Future)result.future().map(status -> this.getResponse(name, (Status)status)).otherwise(t -> this.getResponse(name, (Throwable)t)));
            });
            return this;
        }

        public HealthCheckHandler register(String name, long timeout, Handler<Promise<Status>> procedure) {
            return this.register(name, procedure);
        }

        public HealthCheckHandler unregister(String name) {
            this.registry.remove(name);
            return null;
        }

        public HealthCheckHandler resultMapper(Function<CheckResult, Future<CheckResult>> resultMapper) {
            throw new UnsupportedOperationException();
        }
    }
}

