/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.cache;

import com.github.benmanes.caffeine.cache.Cache;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.cache.BasicExpiringValue;
import org.eclipse.hono.cache.ExpiringValue;
import org.eclipse.hono.cache.ExpiringValueCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineBasedExpiringValueCache<V>
implements ExpiringValueCache<Object, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineBasedExpiringValueCache.class);
    private final Cache<Object, Object> cache;

    public CaffeineBasedExpiringValueCache(Cache<Object, Object> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public void put(Object key, V value, Instant expirationTime) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(expirationTime);
        if (!Instant.now().isBefore(expirationTime)) {
            throw new IllegalArgumentException("value is already expired");
        }
        BasicExpiringValue expiringValue = new BasicExpiringValue(value, expirationTime);
        this.cache.put(key, (Object)expiringValue);
    }

    public void put(Object key, V value, Duration maxAge) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(maxAge);
        this.put(key, value, Instant.now().plus(maxAge));
    }

    public V get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.cache.getIfPresent(key);
        if (value == null) {
            LOG.trace("cache miss [key: {}]", key);
            return null;
        }
        ExpiringValue v = (ExpiringValue)value;
        if (v.isExpired()) {
            LOG.trace("cache hit expired [key: {}]", key);
            this.cache.invalidate(key);
            return null;
        }
        LOG.trace("cache hit [key: {}]", key);
        return (V)v.getValue();
    }
}

