/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.tenant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.service.management.tenant.Adapter;
import org.eclipse.hono.service.management.tenant.TrustedCertificateAuthority;
import org.eclipse.hono.util.ResourceLimits;
import org.eclipse.hono.util.TenantTracingConfig;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Tenant {
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="ext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> extensions = new HashMap<String, Object>();
    @JsonProperty(value="defaults")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> defaults = new HashMap<String, Object>();
    @JsonProperty(value="adapters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Adapter> adapters = new LinkedList<Adapter>();
    @JsonProperty(value="minimum-message-size")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int minimumMessageSize = 0;
    @JsonProperty(value="resource-limits")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private ResourceLimits resourceLimits;
    @JsonProperty(value="tracing")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private TenantTracingConfig tracing;
    @JsonProperty(value="trusted-ca")
    private List<TrustedCertificateAuthority> trustedCertificateAuthorities;

    @JsonIgnore
    public final boolean isValid() {
        return Optional.ofNullable(this.trustedCertificateAuthorities).map(list -> list.stream().allMatch(ca -> ca.isValid())).orElse(true);
    }

    public final Tenant setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final Tenant setExtensions(Map<String, Object> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            this.extensions.putAll(extensions);
        }
        return this;
    }

    public final Tenant putExtension(String key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.extensions.put(key, value);
        return this;
    }

    public final Map<String, Object> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    public final Tenant setDefaults(Map<String, Object> defaults) {
        this.defaults.clear();
        if (defaults != null) {
            this.defaults.putAll(defaults);
        }
        return this;
    }

    public final Map<String, Object> getDefaults() {
        return Collections.unmodifiableMap(this.defaults);
    }

    public final Tenant setAdapters(List<Adapter> adapters) {
        if (adapters != null) {
            if (adapters.isEmpty()) {
                throw new IllegalArgumentException("Atleast one adapter must be configured");
            }
            Set uniqueAdapterTypes = adapters.stream().map(Adapter::getType).collect(Collectors.toSet());
            if (adapters.size() != uniqueAdapterTypes.size()) {
                throw new IllegalArgumentException("Each adapter must have a unique type");
            }
        }
        this.adapters.clear();
        if (adapters != null) {
            this.adapters.addAll(adapters);
        }
        return this;
    }

    public final List<Adapter> getAdapters() {
        return Collections.unmodifiableList(this.adapters);
    }

    public final Tenant addAdapterConfig(Adapter configuration) {
        if (configuration == null) {
            return this;
        }
        boolean hasAdapterOfSameType = this.adapters.stream().anyMatch(adapter -> configuration.getType().equals(adapter.getType()));
        if (hasAdapterOfSameType) {
            throw new IllegalArgumentException(String.format("Already an adapter of the type [%s] exists", configuration.getType()));
        }
        this.adapters.add(configuration);
        return this;
    }

    public final Integer getMinimumMessageSize() {
        return this.minimumMessageSize;
    }

    public final Tenant setMinimumMessageSize(Integer minimumMessageSize) {
        if (minimumMessageSize == null || minimumMessageSize < 0) {
            throw new IllegalArgumentException("minimum message size must be >= 0");
        }
        this.minimumMessageSize = minimumMessageSize;
        return this;
    }

    public final ResourceLimits getResourceLimits() {
        return this.resourceLimits;
    }

    public final Tenant setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = resourceLimits;
        return this;
    }

    public final TenantTracingConfig getTracing() {
        return this.tracing;
    }

    public final Tenant setTracing(TenantTracingConfig tracing) {
        this.tracing = tracing;
        return this;
    }

    public List<TrustedCertificateAuthority> getTrustedCertificateAuthorities() {
        return this.trustedCertificateAuthorities;
    }

    public Tenant setTrustedCertificateAuthorities(List<TrustedCertificateAuthority> trustedCertificateAuthorities) {
        if (trustedCertificateAuthorities != null) {
            this.trustedCertificateAuthorities = Collections.unmodifiableList(trustedCertificateAuthorities);
        }
        return this;
    }

    @JsonIgnore
    public Set<X500Principal> getTrustedCertificateAuthoritySubjectDNs() {
        return Optional.ofNullable(this.trustedCertificateAuthorities).map(list -> list.stream().map(ca -> ca.getSubjectDn()).collect(Collectors.toSet())).orElse(Set.of());
    }

    public boolean hasTrustedCertificateAuthoritySubjectDN(X500Principal subjectDn) {
        Objects.requireNonNull(subjectDn);
        return Optional.ofNullable(this.trustedCertificateAuthorities).map(list -> list.stream().anyMatch(ca -> subjectDn.equals(ca.getSubjectDn()))).orElse(false);
    }
}

