/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.Util;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.EventBusMessage;

public abstract class EventBusTenantManagementAdapter
extends EventBusService {
    private static final String SPAN_NAME_GET_TENANT = "get Tenant from management API";
    private static final String SPAN_NAME_CREATE_TENANT = "create Tenant from management API";
    private static final String SPAN_NAME_UPDATE_TENANT = "update Tenant from management API";
    private static final String SPAN_NAME_REMOVE_TENANT = "remove Tenant from management API";

    protected abstract TenantManagementService getService();

    @Override
    protected final String getEventBusAddress() {
        return "tenant.mgmt.in";
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "create": {
                return this.processCreateRequest(requestMessage);
            }
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
            case "delete": {
                return this.processDeleteRequest(requestMessage);
            }
        }
        return this.processCustomTenantMessage(requestMessage);
    }

    private Future<EventBusMessage> processCreateRequest(EventBusMessage request) {
        Future resultFuture;
        Optional<String> tenantId = Optional.ofNullable(request.getTenant());
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_CREATE_TENANT, spanContext, this.tracer, tenantId.orElse("<auto>"), ((Object)((Object)this)).getClass().getSimpleName());
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("creating tenant [{}]", (Object)tenantId.orElse("<auto>"));
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            Future addResult = Future.future();
            this.getService().add(tenantId, payload, span, (Handler<AsyncResult<OperationResult<Id>>>)addResult);
            resultFuture = addResult.map(res -> {
                String createdTenantId = Optional.ofNullable((Id)res.getPayload()).map(Id::getId).orElse(null);
                return res.createResponse(request, JsonObject::mapFrom).setTenant(createdTenantId);
            });
        } else {
            this.log.debug("request contains malformed payload");
            TracingHelper.logError((Span)span, (String)"request contains malformed payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_UPDATE_TENANT, spanContext, this.tracer, tenantId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null) {
            this.log.debug("missing tenant ID");
            TracingHelper.logError((Span)span, (String)"missing tenant ID");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else if (this.isValidRequestPayload(payload)) {
            this.log.debug("updating tenant [{}]", (Object)tenantId);
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            Future updateResult = Future.future();
            this.getService().update(tenantId, payload, resourceVersion, span, (Handler<AsyncResult<OperationResult<Void>>>)updateResult);
            resultFuture = updateResult.map(res -> res.createResponse(request, JsonObject::mapFrom).setTenant(tenantId));
        } else {
            this.log.debug("request contains malformed payload");
            TracingHelper.logError((Span)span, (String)"request contains malformed payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    private Future<EventBusMessage> processDeleteRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_REMOVE_TENANT, spanContext, this.tracer, tenantId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null) {
            this.log.debug("missing tenant ID");
            TracingHelper.logError((Span)span, (String)"missing tenant ID");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("deleting tenant [{}]", (Object)tenantId);
            Future removeResult = Future.future();
            this.getService().remove(tenantId, resourceVersion, span, (Handler<AsyncResult<Result<Void>>>)removeResult);
            resultFuture = removeResult.map(res -> res.createResponse(request, JsonObject::mapFrom).setTenant(tenantId));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_GET_TENANT, spanContext, this.tracer, tenantId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null) {
            this.log.debug("missing tenant ID");
            TracingHelper.logError((Span)span, (String)"missing tenant ID");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("retrieving tenant [id: {}]", (Object)tenantId);
            Future readResult = Future.future();
            this.getService().read(tenantId, span, (Handler<AsyncResult<OperationResult<Tenant>>>)readResult);
            resultFuture = readResult.map(res -> res.createResponse(request, JsonObject::mapFrom).setTenant(tenantId));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    boolean isValidRequestPayload(JsonObject payload) {
        Objects.requireNonNull(payload);
        try {
            return ((Tenant)payload.mapTo(Tenant.class)).isValid();
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Error parsing payload of tenant request", (Throwable)e);
            return false;
        }
    }

    protected final void addNotPresentFieldsWithDefaultValuesForTenant(JsonObject checkedPayload) {
        JsonArray adapters;
        if (!checkedPayload.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            checkedPayload.put("enabled", Boolean.TRUE);
        }
        if ((adapters = checkedPayload.getJsonArray("adapters")) != null) {
            adapters.forEach(elem -> this.addNotPresentFieldsWithDefaultValuesForAdapter((JsonObject)elem));
        }
    }

    private void addNotPresentFieldsWithDefaultValuesForAdapter(JsonObject adapter) {
        if (!adapter.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            adapter.put("enabled", Boolean.TRUE);
        }
        if (!adapter.containsKey("device-authentication-required")) {
            this.log.trace("adding 'device-authentication-required' key to adapter payload");
            adapter.put("device-authentication-required", Boolean.TRUE);
        }
    }

    protected Future<EventBusMessage> processCustomTenantMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }
}

