/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.tenant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Adapter {
    private Boolean enabled = Boolean.FALSE;
    @JsonProperty(required=true)
    private String type;
    @JsonProperty(value="device-authentication-required")
    private Boolean deviceAuthenticationRequired = Boolean.TRUE;
    @JsonProperty(value="ext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> extensions = new HashMap<String, Object>();

    public Adapter(@JsonProperty(value="type") String type) {
        Objects.requireNonNull(type);
        this.type = type;
    }

    public final Adapter setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final String getType() {
        return this.type;
    }

    public final Adapter setDeviceAuthenticationRequired(Boolean required) {
        this.deviceAuthenticationRequired = required;
        return this;
    }

    public final Boolean isDeviceAuthenticationRequired() {
        return this.deviceAuthenticationRequired;
    }

    public final Adapter setExtensions(Map<String, Object> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            this.extensions.putAll(extensions);
        }
        return this;
    }

    public final Map<String, Object> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    public final Adapter putExtension(String key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.extensions.put(key, value);
        return this;
    }
}

