/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Device {
    private Boolean enabled;
    @JsonProperty(value="ext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> extensions = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> defaults = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> via = new LinkedList<String>();

    public Device() {
    }

    public Device(Device other) {
        Objects.requireNonNull(other);
        this.enabled = other.enabled;
        if (other.extensions != null) {
            this.extensions = new HashMap<String, Object>(other.extensions);
        }
        if (other.defaults != null) {
            this.defaults = new HashMap<String, Object>(other.defaults);
        }
        if (other.via != null) {
            this.via = new ArrayList<String>(other.via);
        }
    }

    public Device setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Device setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public Device putExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Device setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
        return this;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    public List<String> getVia() {
        return this.via;
    }

    public Device setVia(List<String> via) {
        this.via = via;
        return this;
    }
}

