/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Util;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.credentials.CredentialsManagementService;
import org.eclipse.hono.service.management.credentials.GenericCredential;
import org.eclipse.hono.service.management.credentials.PasswordCredential;
import org.eclipse.hono.service.management.credentials.PskCredential;
import org.eclipse.hono.service.management.credentials.X509CertificateCredential;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.EventBusMessage;

public abstract class EventBusCredentialsManagementAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_GET_CREDENTIAL = "get Credential from management API";
    private static final String SPAN_NAME_UPDATE_CREDENTIAL = "update Credential from management API";

    protected abstract CredentialsManagementService getService();

    @Override
    protected String getEventBusAddress() {
        return "credentials.mgmt.in";
    }

    @Override
    protected Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
        }
        return this.processCustomCredentialsMessage(requestMessage);
    }

    protected Future<EventBusMessage> processCustomCredentialsMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        JsonObject payload = request.getJsonPayload();
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_UPDATE_CREDENTIAL, spanContext, this.tracer, tenantId, deviceId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null) {
            this.log.debug("missing tenant ID");
            TracingHelper.logError((Span)span, (String)"missing tenant ID");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant ID"));
        } else if (payload == null) {
            this.log.debug("missing payload");
            TracingHelper.logError((Span)span, (String)"missing payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400, "missing payload"));
        } else {
            resultFuture = this.credentialsFromPayload(request).compose(secrets -> {
                Future result = Future.future();
                this.getService().set(tenantId, deviceId, resourceVersion, (List<CommonCredential>)secrets, span, (Handler<AsyncResult<OperationResult<Void>>>)result);
                return result.map(res -> res.createResponse(request, id -> null).setDeviceId(deviceId));
            });
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected CommonCredential decodeCredential(JsonObject object) {
        if (object == null) {
            return null;
        }
        String type = object.getString("type");
        if (type == null || type.isEmpty()) {
            throw new IllegalStateException("'type' field must be set");
        }
        return this.decodeCredential(type, object);
    }

    protected CommonCredential decodeCredential(String type, JsonObject object) {
        switch (type) {
            case "hashed-password": {
                return (CommonCredential)object.mapTo(PasswordCredential.class);
            }
            case "psk": {
                return (CommonCredential)object.mapTo(PskCredential.class);
            }
            case "x509-cert": {
                return (CommonCredential)object.mapTo(X509CertificateCredential.class);
            }
        }
        return (CommonCredential)object.mapTo(GenericCredential.class);
    }

    protected List<CommonCredential> decodeCredentials(JsonArray objects) {
        return objects.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(this::decodeCredential).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected Future<List<CommonCredential>> credentialsFromPayload(EventBusMessage request) {
        try {
            return Future.succeededFuture((Object)Optional.ofNullable(request.getJsonPayload()).map(json -> this.decodeCredentials(json.getJsonArray("credentials"))).orElseGet(ArrayList::new));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, (Throwable)e));
        }
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_GET_CREDENTIAL, spanContext, this.tracer, tenantId, deviceId, ((Object)((Object)this)).getClass().getSimpleName());
        Future getResult = Future.future();
        this.getService().get(tenantId, deviceId, span, (Handler<AsyncResult<OperationResult<List<CommonCredential>>>>)getResult);
        Future resultFuture = getResult.map(res -> res.createResponse(request, credentials -> {
            JsonObject ret = new JsonObject();
            JsonArray credentialsArray = new JsonArray();
            for (CommonCredential credential : credentials) {
                credentialsArray.add(JsonObject.mapFrom((Object)credential));
            }
            ret.put("credentials", credentialsArray);
            return ret;
        }).setDeviceId(deviceId));
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }
}

