/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.time.Instant;
import org.eclipse.hono.annotation.HonoTimestamp;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class CommonSecret {
    @JsonProperty
    private Boolean enabled;
    @JsonProperty(value="not-before")
    @HonoTimestamp
    private Instant notBefore;
    @JsonProperty(value="not-after")
    @HonoTimestamp
    private Instant notAfter;
    @JsonProperty
    private String comment;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public CommonSecret setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    public CommonSecret setNotBefore(Instant notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public CommonSecret setNotAfter(Instant notAfter) {
        this.notAfter = notAfter;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public CommonSecret setComment(String comment) {
        this.comment = comment;
        return this;
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", (Object)this.enabled).add("notBefore", (Object)this.notBefore).add("notAfter", (Object)this.notAfter).add("comment", (Object)this.comment);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    public void checkValidity() {
        if (this.notBefore != null && this.notAfter != null && this.notBefore.isAfter(this.notAfter)) {
            throw new IllegalStateException("'not-before' must be before 'not-after'");
        }
    }
}

