/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.Objects;
import org.eclipse.hono.tracing.TracingHelper;

public class Util {
    private Util() {
    }

    public static final Span newChildSpan(String operationName, SpanContext spanContext, Tracer tracer, String tenantId, String deviceId, String className) {
        Objects.requireNonNull(operationName);
        Tracer.SpanBuilder spanBuilder = TracingHelper.buildChildSpan((Tracer)tracer, (SpanContext)spanContext, (String)operationName).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), className).withTag(Tags.SPAN_KIND.getKey(), "server");
        if (tenantId != null) {
            spanBuilder.withTag("tenant_id", tenantId);
        }
        if (deviceId != null) {
            spanBuilder.withTag("device_id", deviceId);
        }
        return spanBuilder.start();
    }

    public static final Span newChildSpan(String operationName, SpanContext spanContext, Tracer tracer, String tenantId, String className) {
        return Util.newChildSpan(operationName, spanContext, tracer, tenantId, null, className);
    }
}

