/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.service.auth.device.AbstractDeviceCredentials;

public class SubjectDnCredentials
extends AbstractDeviceCredentials {
    private SubjectDnCredentials(String tenantId, String authId) {
        super(tenantId, authId);
    }

    public static SubjectDnCredentials create(String tenantId, String subjectDn) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        return SubjectDnCredentials.create(tenantId, new X500Principal(subjectDn));
    }

    public static SubjectDnCredentials create(String tenantId, X500Principal subjectDn) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        return new SubjectDnCredentials(tenantId, subjectDn.getName("RFC2253"));
    }

    @Override
    public String getType() {
        return "x509-cert";
    }
}

