/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.AuthHandler;
import org.eclipse.hono.service.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.util.ExecutionContext;

public class ChainAuthHandler<T extends ExecutionContext>
extends ExecutionContextAuthHandler<T> {
    private final List<AuthHandler<T>> handlerChain = new LinkedList<AuthHandler<T>>();

    public ChainAuthHandler() {
        super(null);
    }

    public final ChainAuthHandler<T> append(AuthHandler<T> handler) {
        this.handlerChain.add(Objects.requireNonNull(handler));
        return this;
    }

    @Override
    public Future<JsonObject> parseCredentials(T context) {
        Future result = Future.future();
        this.parseCredentials(0, context, null, (Handler<AsyncResult<JsonObject>>)result);
        return result;
    }

    private void parseCredentials(int idx, T context, Throwable lastException, Handler<AsyncResult<JsonObject>> resultHandler) {
        if (idx >= this.handlerChain.size()) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)lastException));
        } else {
            AuthHandler<T> handler = this.handlerChain.get(idx);
            handler.parseCredentials(context).setHandler(r -> {
                if (r.failed()) {
                    this.parseCredentials(idx + 1, context, r.cause(), resultHandler);
                } else {
                    context.put(AUTH_PROVIDER_CONTEXT_KEY, (Object)handler.getAuthProvider());
                    resultHandler.handle((Object)Future.succeededFuture((Object)((JsonObject)r.result())));
                }
            });
        }
    }
}

