/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.Objects;
import org.eclipse.hono.service.Endpoint;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractEndpoint
implements Endpoint {
    protected final Vertx vertx;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Tracer tracer = NoopTracerFactory.create();

    protected AbstractEndpoint(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    @Autowired(required=false)
    public final void setTracer(Tracer opentracingTracer) {
        this.logger.info("using OpenTracing Tracer implementation [{}]", (Object)opentracingTracer.getClass().getName());
        this.tracer = Objects.requireNonNull(opentracingTracer);
    }

    @Override
    public final Future<Void> start() {
        Future result = Future.future();
        if (this.vertx == null) {
            result.fail((Throwable)new IllegalStateException("Vert.x instance must be set"));
        } else {
            this.doStart((Future<Void>)result);
        }
        return result;
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    @Override
    public final Future<Void> stop() {
        Future result = Future.future();
        this.doStop((Future<Void>)result);
        return result;
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
    }

    protected final DeliveryOptions createEventBusMessageDeliveryOptions(SpanContext spanContext) {
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setSendTimeout(3000L);
        TracingHelper.injectSpanContext((Tracer)this.tracer, (SpanContext)spanContext, (DeliveryOptions)deliveryOptions);
        return deliveryOptions;
    }
}

