/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.hono.service.management.credentials.CommonSecret;
import org.eclipse.hono.service.management.credentials.CredentialTypeResolver;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonTypeIdResolver(value=CredentialTypeResolver.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class CommonCredential {
    @JsonProperty(value="auth-id")
    private String authId;
    @JsonProperty
    private Boolean enabled;
    @JsonProperty
    private String comment;
    @JsonProperty(value="ext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> extensions = new HashMap<String, Object>();

    protected abstract List<? extends CommonSecret> getSecrets();

    public String getAuthId() {
        return this.authId;
    }

    public CommonCredential setAuthId(String authId) {
        this.authId = authId;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public CommonCredential setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public CommonCredential setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public CommonCredential setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public CommonCredential putExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
        return this;
    }

    public void checkValidity() {
        if (this.authId == null || this.authId.isEmpty()) {
            throw new IllegalStateException("missing auth ID");
        }
    }
}

