/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.EventBusMessage;

public abstract class EventBusCredentialsAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_GET_CREDENTIALS = "get Credentials";

    protected abstract CredentialsService getService();

    @Override
    protected String getEventBusAddress() {
        return "credentials.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        String operation = request.getOperation();
        switch (CredentialsConstants.CredentialsAction.from((String)operation)) {
            case get: {
                return this.processGetRequest(request);
            }
        }
        return this.processCustomCredentialsMessage(request);
    }

    protected Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        Span span = this.newChildSpan(SPAN_NAME_GET_CREDENTIALS, request.getSpanContext(), tenantId);
        if (tenantId == null || payload == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            String type = EventBusCredentialsAdapter.removeTypesafeValueForField(String.class, payload, "type");
            String authId = EventBusCredentialsAdapter.removeTypesafeValueForField(String.class, payload, "auth-id");
            String deviceId = EventBusCredentialsAdapter.removeTypesafeValueForField(String.class, payload, "device-id");
            if (type == null) {
                TracingHelper.logError((Span)span, (String)"missing type");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else if (authId != null && deviceId == null) {
                resultFuture = this.processGetByAuthIdRequest(request, tenantId, payload, type, authId, span);
            } else if (deviceId != null && authId == null) {
                resultFuture = this.processGetByDeviceIdRequest(request, tenantId, type, deviceId, span);
            } else {
                TracingHelper.logError((Span)span, (String)String.format("invalid search criteria [type: %s, device-id: %s, auth-id: %s]", type, deviceId, authId));
                this.log.debug("get credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            }
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processGetByDeviceIdRequest(EventBusMessage request, String tenantId, String type, String deviceId, Span span) {
        return Future.failedFuture((Throwable)new ClientErrorException(501));
    }

    private Future<EventBusMessage> processGetByAuthIdRequest(EventBusMessage request, String tenantId, JsonObject payload, String type, String authId, Span span) {
        this.log.debug("getting credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
        TracingHelper.TAG_CREDENTIALS_TYPE.set(span, type);
        TracingHelper.TAG_AUTH_ID.set(span, authId);
        Future result = Future.future();
        this.getService().get(tenantId, type, authId, payload, span, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result);
        return result.map(res -> {
            String deviceIdFromPayload = Optional.ofNullable((JsonObject)res.getPayload()).map(p -> EventBusCredentialsAdapter.getTypesafeValueForField(String.class, p, "device-id")).orElse(null);
            if (deviceIdFromPayload != null) {
                span.setTag("device_id", deviceIdFromPayload);
            }
            return request.getResponse(res.getStatus()).setDeviceId(deviceIdFromPayload).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective());
        });
    }

    protected final Span newChildSpan(String operationName, SpanContext spanContext, String tenantId) {
        Objects.requireNonNull(operationName);
        Tracer.SpanBuilder spanBuilder = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)operationName).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), ((Object)((Object)this)).getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "server");
        if (tenantId != null) {
            spanBuilder.withTag("tenant_id", tenantId);
        }
        return spanBuilder.start();
    }

    protected Future<EventBusMessage> processCustomCredentialsMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }
}

