/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.resourcelimits;

import java.util.Objects;
import org.eclipse.hono.util.PortConfigurationHelper;

public final class PrometheusBasedResourceLimitChecksConfig {
    public static final int DEFAULT_CACHE_MIN_SIZE = 20;
    public static final long DEFAULT_CACHE_MAX_SIZE = 1000L;
    public static final long DEFAULT_CACHE_TIMEOUT = 600L;
    private String host;
    private int port = 9090;
    private int cacheMinSize = 20;
    private long cacheMaxSize = 1000L;
    private long cacheTimeout = 600L;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = Objects.requireNonNull(host);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (!PortConfigurationHelper.isValidPort((int)port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.port = port;
    }

    public int getCacheMinSize() {
        return this.cacheMinSize;
    }

    public void setCacheMinSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("minimum cache size must not be negative");
        }
        this.cacheMinSize = size;
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("maximum cache size must not be negative");
        }
        this.cacheMaxSize = size;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("default cache timeout must be greater than zero");
        }
        this.cacheTimeout = timeout;
    }
}

