/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.util.BaseMessageFilter;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrationMessageFilter
extends BaseMessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationMessageFilter.class);

    private RegistrationMessageFilter() {
    }

    public static boolean verify(ResourceIdentifier linkTarget, Message msg) {
        Object correlationId = MessageHelper.getCorrelationId((Message)msg);
        if (!RegistrationMessageFilter.hasValidDeviceId((ResourceIdentifier)linkTarget, (Message)msg)) {
            return false;
        }
        if (correlationId == null) {
            LOG.trace("message has neither a message-id nor correlation-id");
            return false;
        }
        if (msg.getSubject() == null) {
            LOG.trace("message [correlation ID: {}] does not contain a subject", correlationId);
            return false;
        }
        if (msg.getReplyTo() == null) {
            LOG.trace("message [correlation ID: {}] contains no reply-to address", correlationId);
            return false;
        }
        return true;
    }
}

