/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.RegistrationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistrationService
implements RegistrationService {
    public static final int DEFAULT_MAX_AGE_SECONDS = 300;
    private static final Logger log = LoggerFactory.getLogger(AbstractRegistrationService.class);

    protected abstract void getDevice(String var1, String var2, Span var3, Handler<AsyncResult<RegistrationResult>> var4);

    @Override
    public final void assertRegistration(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.assertRegistration(tenantId, deviceId, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, Span span, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        Objects.requireNonNull(resultHandler);
        Future getResultTracker = Future.future();
        this.getDevice(tenantId, deviceId, span, (Handler<AsyncResult<RegistrationResult>>)getResultTracker);
        getResultTracker.compose(result -> {
            if (this.isDeviceEnabled((RegistrationResult)result)) {
                JsonObject deviceData = ((JsonObject)result.getPayload()).getJsonObject("data");
                return Future.succeededFuture((Object)this.createSuccessfulRegistrationResult(tenantId, deviceId, deviceData));
            }
            TracingHelper.logError((Span)span, (String)"device not enabled");
            return Future.succeededFuture((Object)RegistrationResult.from((int)404));
        }).setHandler(resultHandler);
    }

    @Override
    public final void assertRegistration(String tenantId, String deviceId, String gatewayId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.assertRegistration(tenantId, deviceId, gatewayId, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, String gatewayId, Span span, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(span);
        Objects.requireNonNull(resultHandler);
        Future deviceInfoTracker = Future.future();
        Future gatewayInfoTracker = Future.future();
        this.getDevice(tenantId, deviceId, span, (Handler<AsyncResult<RegistrationResult>>)deviceInfoTracker);
        this.getDevice(tenantId, gatewayId, span, (Handler<AsyncResult<RegistrationResult>>)gatewayInfoTracker);
        CompositeFuture.all((Future)deviceInfoTracker, (Future)gatewayInfoTracker).compose(ok -> {
            RegistrationResult deviceResult = (RegistrationResult)deviceInfoTracker.result();
            RegistrationResult gatewayResult = (RegistrationResult)gatewayInfoTracker.result();
            if (!this.isDeviceEnabled(deviceResult)) {
                log.debug("device not enabled");
                TracingHelper.logError((Span)span, (String)"device not enabled");
                return Future.succeededFuture((Object)RegistrationResult.from((int)404));
            }
            if (!this.isDeviceEnabled(gatewayResult)) {
                log.debug("gateway not enabled");
                TracingHelper.logError((Span)span, (String)"gateway not enabled");
                return Future.succeededFuture((Object)RegistrationResult.from((int)403));
            }
            JsonObject deviceData = ((JsonObject)deviceResult.getPayload()).getJsonObject("data", new JsonObject());
            JsonObject gatewayData = ((JsonObject)gatewayResult.getPayload()).getJsonObject("data", new JsonObject());
            if (log.isDebugEnabled()) {
                log.debug("Device data: {}", (Object)deviceData.encodePrettily());
                log.debug("Gateway data: {}", (Object)gatewayData.encodePrettily());
            }
            if (this.isGatewayAuthorized(gatewayId, gatewayData, deviceId, deviceData)) {
                return Future.succeededFuture((Object)this.createSuccessfulRegistrationResult(tenantId, deviceId, deviceData));
            }
            log.debug("gateway not authorized");
            TracingHelper.logError((Span)span, (String)"gateway not authorized");
            return Future.succeededFuture((Object)RegistrationResult.from((int)403));
        }).setHandler(resultHandler);
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(gatewayData);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(deviceData);
        Object obj = deviceData.getValue("via");
        if (obj instanceof JsonArray) {
            return ((JsonArray)obj).stream().filter(String.class::isInstance).anyMatch(gatewayId::equals);
        }
        if (obj instanceof String) {
            return gatewayId.equals(obj);
        }
        return false;
    }

    private RegistrationResult createSuccessfulRegistrationResult(String tenantId, String deviceId, JsonObject deviceData) {
        return RegistrationResult.from((int)200, (JsonObject)this.getAssertionPayload(tenantId, deviceId, deviceData), (CacheDirective)this.getRegistrationAssertionCacheDirective(deviceId, tenantId));
    }

    protected final JsonObject getAssertionPayload(String tenantId, String deviceId, JsonObject registrationInfo) {
        JsonObject defaults;
        JsonObject result = new JsonObject().put("device-id", deviceId);
        JsonArray viaObj = this.getSupportedGatewaysForDevice(tenantId, deviceId, registrationInfo);
        if (!viaObj.isEmpty()) {
            result.put("via", viaObj);
        }
        if ((defaults = registrationInfo.getJsonObject("defaults")) != null) {
            result.put("defaults", defaults);
        }
        return result;
    }

    protected boolean isGatewaySupportedForDevice(String tenantId, String deviceId, JsonObject registrationInfo) {
        Object viaObj = registrationInfo.getValue("via");
        return viaObj instanceof String && !((String)viaObj).isEmpty() || viaObj instanceof JsonArray && !((JsonArray)viaObj).isEmpty();
    }

    private boolean isDeviceEnabled(RegistrationResult registrationResult) {
        return registrationResult.isOk() && this.isDeviceEnabled(((JsonObject)registrationResult.getPayload()).getJsonObject("data"));
    }

    private boolean isDeviceEnabled(JsonObject registrationData) {
        return registrationData.getBoolean("enabled", Boolean.TRUE);
    }

    protected CacheDirective getRegistrationAssertionCacheDirective(String deviceId, String tenantId) {
        return CacheDirective.maxAgeDirective((long)300L);
    }

    protected JsonArray getSupportedGatewaysForDevice(String tenantId, String deviceId, JsonObject registrationInfo) {
        Object viaObj = registrationInfo.getValue("via");
        if (viaObj instanceof String) {
            viaObj = new JsonArray().add(viaObj);
        }
        return viaObj instanceof JsonArray ? (JsonArray)viaObj : new JsonArray(Collections.emptyList());
    }
}

