/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.Util;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.util.EventBusMessage;

public abstract class EventBusDeviceManagementAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_CREATE_DEVICE = "create Device from management API";
    private static final String SPAN_NAME_GET_DEVICE = "get Device from management API";
    private static final String SPAN_NAME_UPDATE_DEVICE = "update Device from management API";
    private static final String SPAN_NAME_REMOVE_DEVICE = "remove Device from management API";

    protected abstract DeviceManagementService getService();

    @Override
    protected String getEventBusAddress() {
        return "device.mgmt.in";
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "create": {
                return this.processCreateRequest(requestMessage);
            }
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
            case "delete": {
                return this.processDeleteRequest(requestMessage);
            }
        }
        return this.processCustomDeviceMessage(requestMessage);
    }

    protected Future<EventBusMessage> processCustomDeviceMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private static Future<Device> deviceFromPayload(EventBusMessage request) {
        try {
            return Future.succeededFuture((Object)EventBusDeviceManagementAdapter.fromPayload(request));
        }
        catch (IllegalArgumentException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, (Throwable)e));
        }
    }

    static Device fromPayload(EventBusMessage request) throws ClientErrorException {
        return Optional.ofNullable(request.getJsonPayload()).map(json -> (Device)json.mapTo(Device.class)).orElseGet(Device::new);
    }

    private Future<EventBusMessage> processCreateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        Optional<String> deviceId = Optional.ofNullable(request.getDeviceId());
        SpanContext spanContext = request.getSpanContext();
        Future<Device> deviceFuture = EventBusDeviceManagementAdapter.deviceFromPayload(request);
        Span span = Util.newChildSpan(SPAN_NAME_CREATE_DEVICE, spanContext, this.tracer, tenantId, deviceId.orElse("unspecified"), ((Object)((Object)this)).getClass().getSimpleName());
        return deviceFuture.compose(device -> {
            this.log.debug("registering device [{}] for tenant [{}]", (Object)deviceId.orElse("<auto>"), (Object)tenantId);
            Future result = Future.future();
            this.getService().createDevice(tenantId, deviceId, (Device)device, span, (Handler<AsyncResult<OperationResult<Id>>>)result);
            return result.map(res -> {
                String createdDeviceId = Optional.ofNullable((Id)res.getPayload()).map(Id::getId).orElse(null);
                return res.createResponse(request, JsonObject::mapFrom).setDeviceId(createdDeviceId);
            });
        });
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_GET_DEVICE, spanContext, this.tracer, tenantId, deviceId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.getService().readDevice(tenantId, deviceId, span, (Handler<AsyncResult<OperationResult<Device>>>)result);
        return result.map(res -> res.createResponse(request, JsonObject::mapFrom).setDeviceId(deviceId));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_UPDATE_DEVICE, spanContext, this.tracer, tenantId, deviceId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        Future<Device> deviceFuture = EventBusDeviceManagementAdapter.deviceFromPayload(request);
        return deviceFuture.compose(device -> {
            this.log.debug("updating registration information for device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
            Future result = Future.future();
            this.getService().updateDevice(tenantId, deviceId, (Device)device, resourceVersion, span, (Handler<AsyncResult<OperationResult<Id>>>)result);
            return result.map(res -> res.createResponse(request, JsonObject::mapFrom).setDeviceId(deviceId));
        });
    }

    private Future<EventBusMessage> processDeleteRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        SpanContext spanContext = request.getSpanContext();
        Span span = Util.newChildSpan(SPAN_NAME_REMOVE_DEVICE, spanContext, this.tracer, tenantId, deviceId, ((Object)((Object)this)).getClass().getSimpleName());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deleting device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.getService().deleteDevice(tenantId, deviceId, resourceVersion, span, (Handler<AsyncResult<Result<Void>>>)result);
        return result.map(res -> res.createResponse(request, id -> null).setDeviceId(deviceId));
    }
}

