/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.util.EventConstants;

public final class HttpUtils {
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_JSON_UTF8 = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_TEXT_UTF8 = "text/plain; charset=utf-8";
    public static final int HTTP_TOO_MANY_REQUESTS = 429;

    private HttpUtils() {
    }

    public static void badRequest(RoutingContext ctx, String msg) {
        HttpUtils.failWithHeaders(ctx, (ServiceInvocationException)new ClientErrorException(400, msg), null);
    }

    public static void internalServerError(RoutingContext ctx, String msg) {
        HttpUtils.failWithHeaders(ctx, (ServiceInvocationException)new ServerErrorException(500, msg), null);
    }

    public static void serviceUnavailable(RoutingContext ctx, int retryAfterSeconds) {
        HttpUtils.serviceUnavailable(ctx, retryAfterSeconds, null);
    }

    public static void serviceUnavailable(RoutingContext ctx, int retryAfterSeconds, String detail) {
        HashMap<CharSequence, CharSequence> headers = new HashMap<CharSequence, CharSequence>(1);
        headers.put(HttpHeaders.RETRY_AFTER, String.valueOf(retryAfterSeconds));
        HttpUtils.failWithHeaders(ctx, (ServiceInvocationException)new ServerErrorException(503, detail), headers);
    }

    public static void unauthorized(RoutingContext ctx, String authenticateHeaderValue) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(authenticateHeaderValue);
        HashMap<CharSequence, CharSequence> headers = new HashMap<CharSequence, CharSequence>();
        headers.put("WWW-Authenticate", authenticateHeaderValue);
        HttpUtils.failWithHeaders(ctx, (ServiceInvocationException)new ClientErrorException(401), headers);
    }

    public static void fail(RoutingContext ctx, ServiceInvocationException error) {
        HttpUtils.failWithHeaders(ctx, error, null);
    }

    public static void failWithHeaders(RoutingContext ctx, ServiceInvocationException error, Map<CharSequence, CharSequence> headers) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(error);
        if (!ctx.failed() && !ctx.response().ended()) {
            if (headers != null) {
                for (Map.Entry<CharSequence, CharSequence> header : headers.entrySet()) {
                    ctx.response().putHeader(header.getKey(), header.getValue());
                }
            }
            ctx.fail((Throwable)error);
        }
    }

    public static String getContentType(RoutingContext ctx) {
        return Objects.requireNonNull(ctx).parsedHeaders().contentType().value();
    }

    public static boolean isEmptyNotification(RoutingContext ctx) {
        return Optional.ofNullable(HttpUtils.getContentType(ctx)).map(type -> EventConstants.isEmptyNotificationType((String)type)).orElse(false);
    }

    public static Integer getTimeTillDisconnect(RoutingContext ctx) {
        Objects.requireNonNull(ctx);
        try {
            Optional<String> timeTilDisconnectHeader = Optional.ofNullable(ctx.request().getHeader("hono-ttd"));
            if (timeTilDisconnectHeader.isEmpty()) {
                timeTilDisconnectHeader = Optional.ofNullable(ctx.request().getParam("hono-ttd"));
            }
            if (timeTilDisconnectHeader.isPresent()) {
                return Integer.parseInt(timeTilDisconnectHeader.get());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Duration getTimeToLive(RoutingContext ctx) {
        Objects.requireNonNull(ctx);
        try {
            return Optional.ofNullable(ctx.request().getHeader("hono-ttl")).map(ttlInHeader -> Long.parseLong(ttlInHeader)).map(ttl -> Duration.ofSeconds(ttl)).orElse(Optional.ofNullable(ctx.request().getParam("hono-ttl")).map(ttlInParam -> Long.parseLong(ttlInParam)).map(ttl -> Duration.ofSeconds(ttl)).orElse(null));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Optional<Integer> getCommandResponseStatus(RoutingContext ctx) {
        Objects.requireNonNull(ctx);
        try {
            return Optional.ofNullable(ctx.request().getHeader("hono-cmd-status")).map(cmdResponseStatusHeader -> Optional.of(Integer.parseInt(cmdResponseStatusHeader))).orElse(Optional.ofNullable(ctx.request().getParam("hono-cmd-status")).map(cmdResponseStatusParam -> Optional.of(Integer.parseInt(cmdResponseStatusParam))).orElse(Optional.empty()));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static void setResponseBody(HttpServerResponse response, JsonArray body) {
        Objects.requireNonNull(response);
        if (body != null) {
            HttpUtils.setResponseBody(response, body.toBuffer(), CONTENT_TYPE_JSON_UTF8);
        }
    }

    public static void setResponseBody(HttpServerResponse response, JsonObject body) {
        Objects.requireNonNull(response);
        if (body != null) {
            HttpUtils.setResponseBody(response, body.toBuffer(), CONTENT_TYPE_JSON_UTF8);
        }
    }

    public static void setResponseBody(HttpServerResponse response, Buffer buffer) {
        HttpUtils.setResponseBody(response, buffer, null);
    }

    public static void setResponseBody(HttpServerResponse response, Buffer buffer, String contentType) {
        Objects.requireNonNull(response);
        if (!response.ended() && buffer != null) {
            if (contentType == null) {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE_OCTET_STREAM);
            } else {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
            response.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buffer.length()));
            response.write(buffer);
        }
    }

    public static boolean isError(int status) {
        return status >= 400 && status < 600;
    }
}

