/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.contrib.vertx.ext.web.TracingHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.AbstractEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractHttpEndpoint<T>
extends AbstractEndpoint
implements HttpEndpoint {
    protected static final String KEY_REQUEST_BODY = "KEY_REQUEST_BODY";
    protected static final String PARAM_TENANT_ID = "tenant_id";
    protected static final String PARAM_DEVICE_ID = "device_id";
    protected static final String KEY_RESOURCE_VERSION = "KEY_RESOURCE_VERSION";
    protected T config;

    public AbstractHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Qualifier(value="rest")
    @Autowired(required=false)
    public final void setConfiguration(T props) {
        this.config = Objects.requireNonNull(props);
    }

    protected abstract String getEventBusAddress();

    protected final void extractRequiredJson(RoutingContext ctx, Function<RoutingContext, Object> payloadExtractor) {
        Objects.requireNonNull(payloadExtractor);
        MIMEHeader contentType = ctx.parsedHeaders().contentType();
        if (contentType == null) {
            ctx.fail((Throwable)new ClientErrorException(400, "Missing Content-Type header"));
        } else if (!"application/json".equalsIgnoreCase(contentType.value())) {
            ctx.fail((Throwable)new ClientErrorException(400, "Unsupported Content-Type"));
        } else {
            try {
                if (ctx.getBody() != null) {
                    Object payload = payloadExtractor.apply(ctx);
                    if (payload != null) {
                        ctx.put(KEY_REQUEST_BODY, payload);
                        ctx.next();
                    } else {
                        ctx.fail((Throwable)new ClientErrorException(400, "Null body"));
                    }
                } else {
                    ctx.fail((Throwable)new ClientErrorException(400, "Empty body"));
                }
            }
            catch (DecodeException e) {
                ctx.fail((Throwable)new ClientErrorException(400, "Invalid JSON", (Throwable)e));
            }
        }
    }

    protected final void extractRequiredJsonPayload(RoutingContext ctx) {
        this.extractRequiredJson(ctx, RoutingContext::getBodyAsJson);
    }

    protected final void extractOptionalJsonPayload(RoutingContext ctx) {
        if (ctx.getBody().length() != 0) {
            this.extractRequiredJson(ctx, RoutingContext::getBodyAsJson);
        } else {
            ctx.put(KEY_REQUEST_BODY, (Object)new JsonObject());
            ctx.next();
        }
    }

    protected final void extractRequiredJsonArrayPayload(RoutingContext ctx) {
        this.extractRequiredJson(ctx, body -> {
            JsonArray payload = body.getBodyAsJsonArray();
            if (payload != null && payload.getList() == null) {
                return null;
            }
            return payload;
        });
    }

    protected final BiConsumer<Integer, EventBusMessage> getDefaultResponseHandler(RoutingContext ctx) {
        return this.getDefaultResponseHandler(ctx, (int status) -> false, (Handler<HttpServerResponse>)((Handler)null));
    }

    protected final BiConsumer<Integer, EventBusMessage> getDefaultResponseHandler(RoutingContext ctx, IntPredicate successfulOutcomeFilter, Handler<HttpServerResponse> customHandler) {
        Objects.requireNonNull(successfulOutcomeFilter);
        HttpServerResponse response = ctx.response();
        return (status, responseMessage) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                HttpUtils.setResponseBody(response, responseMessage.getJsonPayload());
            } else if (successfulOutcomeFilter.test((int)status)) {
                HttpUtils.setResponseBody(response, responseMessage.getJsonPayload());
                if (customHandler != null) {
                    customHandler.handle((Object)response);
                }
            }
            response.end();
        };
    }

    protected final BiConsumer<Integer, EventBusMessage> getDefaultResponseHandler(RoutingContext ctx, IntPredicate successfulOutcomeFilter, BiConsumer<HttpServerResponse, EventBusMessage> customHandler) {
        Objects.requireNonNull(successfulOutcomeFilter);
        HttpServerResponse response = ctx.response();
        return (status, result) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                HttpUtils.setResponseBody(response, result.getJsonPayload());
            } else if (successfulOutcomeFilter.test((int)status)) {
                if (customHandler != null) {
                    customHandler.accept(response, (EventBusMessage)result);
                }
                HttpUtils.setResponseBody(response, result.getJsonPayload());
            }
            response.end();
        };
    }

    protected final void sendAction(RoutingContext ctx, JsonObject requestMsg, BiConsumer<Integer, EventBusMessage> responseHandler) {
        DeliveryOptions options = this.createEventBusMessageDeliveryOptions(TracingHandler.serverSpanContext((RoutingContext)ctx));
        this.vertx.eventBus().send(this.getEventBusAddress(), (Object)requestMsg, options, invocation -> {
            if (invocation.failed()) {
                HttpUtils.serviceUnavailable(ctx, 2);
            } else {
                EventBusMessage response = EventBusMessage.fromJson((JsonObject)((JsonObject)((Message)invocation.result()).body()));
                Integer status = response.getStatus();
                String version = response.getResourceVersion();
                if (!Strings.isNullOrEmpty((Object)version)) {
                    ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)version);
                }
                responseHandler.accept(status, response);
            }
        });
    }

    protected final String getTenantParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TENANT_ID);
    }

    protected final String getDeviceIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_DEVICE_ID);
    }

    protected void extractIfMatchVersionParam(RoutingContext ctx) {
        String ifMatchHeader = ctx.request().getHeader(HttpHeaders.IF_MATCH);
        if (!Strings.isNullOrEmpty((Object)ifMatchHeader)) {
            ctx.put(KEY_RESOURCE_VERSION, (Object)ifMatchHeader);
        }
        ctx.next();
    }

    protected final CorsHandler createDefaultCorsHandler(String allowedOrigin) {
        return this.createCorsHandler(allowedOrigin, EnumSet.of(HttpMethod.POST, HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE));
    }

    protected final CorsHandler createCorsHandler(String allowedOrigin, Set<HttpMethod> methods) {
        return CorsHandler.create((String)allowedOrigin).allowedMethods(methods).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.IF_MATCH.toString()).exposedHeader(HttpHeaders.ETAG.toString());
    }
}

