/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationResult;

public abstract class EventBusRegistrationAdapter
extends EventBusService
implements Verticle {
    public static final int DEFAULT_MAX_AGE_SECONDS = 300;
    private static final String SPAN_NAME_ASSERT_DEVICE_REGISTRATION = "assert Device Registration";

    protected abstract RegistrationService getService();

    @Override
    protected String getEventBusAddress() {
        return "registration.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "assert": {
                return this.processAssertRequest(requestMessage);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<EventBusMessage> processAssertRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String gatewayId = request.getGatewayId();
        SpanContext spanContext = request.getSpanContext();
        Span span = this.newChildSpan(SPAN_NAME_ASSERT_DEVICE_REGISTRATION, spanContext, tenantId, deviceId, gatewayId);
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Future result = Future.future();
            if (gatewayId == null) {
                this.log.debug("asserting registration of device [{}] with tenant [{}]", (Object)deviceId, (Object)tenantId);
                this.getService().assertRegistration(tenantId, deviceId, span, (Handler<AsyncResult<RegistrationResult>>)result);
            } else {
                this.log.debug("asserting registration of device [{}] with tenant [{}] for gateway [{}]", new Object[]{deviceId, tenantId, gatewayId});
                this.getService().assertRegistration(tenantId, deviceId, gatewayId, span, (Handler<AsyncResult<RegistrationResult>>)result);
            }
            resultFuture = result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processCustomRegistrationMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    protected boolean isGatewaySupportedForDevice(String tenantId, String deviceId, JsonObject registrationInfo) {
        Object viaObj = registrationInfo.getValue("via");
        return viaObj instanceof String && !((String)viaObj).isEmpty() || viaObj instanceof JsonArray && !((JsonArray)viaObj).isEmpty();
    }

    protected final Span newChildSpan(String operationName, SpanContext spanContext, String tenantId, String deviceId, String gatewayId) {
        Objects.requireNonNull(operationName);
        Tracer.SpanBuilder spanBuilder = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)operationName).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), ((Object)((Object)this)).getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "server");
        if (tenantId != null) {
            spanBuilder.withTag("tenant_id", tenantId);
        }
        if (deviceId != null) {
            spanBuilder.withTag("device_id", deviceId);
        }
        if (gatewayId != null) {
            spanBuilder.withTag("gateway_id", gatewayId);
        }
        return spanBuilder.start();
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<RegistrationResult>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)RegistrationResult.from((int)501)));
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(gatewayData);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(deviceData);
        Object obj = deviceData.getValue("via");
        if (obj instanceof String) {
            return gatewayId.equals(obj);
        }
        if (obj instanceof JsonArray) {
            return ((JsonArray)obj).stream().filter(o -> o instanceof String).anyMatch(id -> gatewayId.equals(id));
        }
        return false;
    }

    protected CacheDirective getRegistrationAssertionCacheDirective(String deviceId, String tenantId) {
        return CacheDirective.maxAgeDirective((long)300L);
    }

    protected static final JsonObject getResultPayload(String deviceId, JsonObject data) {
        return new JsonObject().put("device-id", deviceId).put("data", data);
    }
}

