/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.tenant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.annotation.HonoTimestamp;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TrustedCertificateAuthority {
    private X500Principal subjectDn;
    private byte[] publicKey;
    private X509Certificate cert;
    @JsonProperty(value="algorithm")
    private String keyAlgorithm;
    @JsonProperty(value="not-before")
    @HonoTimestamp
    private Instant notBefore;
    @JsonProperty(value="not-after")
    @HonoTimestamp
    private Instant notAfter;

    @JsonIgnore
    public final boolean isValid() {
        if (this.cert != null) {
            return true;
        }
        if (this.subjectDn == null || this.publicKey == null || this.notBefore == null || this.notAfter == null) {
            return false;
        }
        try {
            String alg = Optional.ofNullable(this.keyAlgorithm).orElse("RSA");
            KeyFactory.getInstance(alg).generatePublic(new X509EncodedKeySpec(this.publicKey));
            return true;
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            return false;
        }
    }

    @JsonProperty(value="subject-dn")
    public final TrustedCertificateAuthority setSubjectDn(String subjectDn) {
        this.setSubjectDn(new X500Principal(subjectDn));
        return this;
    }

    public final TrustedCertificateAuthority setSubjectDn(X500Principal subjectDn) {
        this.subjectDn = subjectDn;
        return this;
    }

    public final X500Principal getSubjectDn() {
        return Optional.ofNullable(this.cert).map(c -> c.getSubjectX500Principal()).orElse(this.subjectDn);
    }

    @JsonProperty(value="subject-dn")
    public final String getSubjectDnAsString() {
        return Optional.ofNullable(this.cert).map(c -> c.getSubjectX500Principal().getName("RFC2253")).orElseGet(() -> Optional.ofNullable(this.subjectDn).map(s -> s.getName("RFC2253")).orElse(null));
    }

    @JsonProperty(value="public-key")
    public final TrustedCertificateAuthority setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @JsonProperty(value="public-key")
    public final byte[] getPublicKey() {
        return Optional.ofNullable(this.cert).map(c -> c.getPublicKey().getEncoded()).orElse(this.publicKey);
    }

    @JsonProperty(value="cert")
    public final TrustedCertificateAuthority setCertificate(byte[] certificate) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        this.cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate));
        return this;
    }

    public final TrustedCertificateAuthority setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    public final String getKeyAlgorithm() {
        return Optional.ofNullable(this.cert).map(c -> c.getPublicKey().getAlgorithm()).orElse(this.keyAlgorithm);
    }

    public final TrustedCertificateAuthority setNotBefore(Instant notBefore) {
        this.notBefore = Objects.requireNonNull(notBefore);
        return this;
    }

    public final Instant getNotBefore() {
        return Optional.ofNullable(this.cert).map(cert -> cert.getNotBefore().toInstant()).orElse(this.notBefore);
    }

    public final TrustedCertificateAuthority setNotAfter(Instant notAfter) {
        this.notAfter = Objects.requireNonNull(notAfter);
        return this;
    }

    public final Instant getNotAfter() {
        return Optional.ofNullable(this.cert).map(cert -> cert.getNotAfter().toInstant()).orElse(this.notAfter);
    }
}

