/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.tenant;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.util.EventBusMessage;
import org.springframework.beans.factory.annotation.Autowired;

public final class TenantManagementHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    @Autowired
    public TenantManagementHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    protected String getEventBusAddress() {
        return "tenant.mgmt.in";
    }

    @Override
    public String getName() {
        return String.format("%s/%s", "v1", "tenants");
    }

    @Override
    public void addRoutes(Router router) {
        String path = String.format("/%s", this.getName());
        String pathWithTenant = String.format("/%s/:%s", this.getName(), "tenant_id");
        router.route(path).handler((Handler)this.createCorsHandler(((ServiceConfigProperties)this.config).getCorsAllowedOrigin(), EnumSet.of(HttpMethod.POST)));
        router.route(pathWithTenant).handler((Handler)this.createDefaultCorsHandler(((ServiceConfigProperties)this.config).getCorsAllowedOrigin()));
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit((long)((ServiceConfigProperties)this.config).getMaxPayloadSize());
        router.post(path).handler((Handler)bodyHandler);
        router.post(path).handler(this::extractOptionalJsonPayload);
        router.post(path).handler(this::createTenant);
        router.post(pathWithTenant).handler((Handler)bodyHandler);
        router.post(pathWithTenant).handler(this::extractOptionalJsonPayload);
        router.post(pathWithTenant).handler(this::updatePayloadWithTenantId);
        router.post(pathWithTenant).handler(this::createTenant);
        router.get(pathWithTenant).handler(this::getTenant);
        router.put(pathWithTenant).handler((Handler)bodyHandler);
        router.put(pathWithTenant).handler(this::extractRequiredJsonPayload);
        router.put(pathWithTenant).handler(this::extractIfMatchVersionParam);
        router.put(pathWithTenant).handler(this::updateTenant);
        router.delete(pathWithTenant).handler(this::extractIfMatchVersionParam);
        router.delete(pathWithTenant).handler(this::deleteTenant);
    }

    protected void updatePayloadWithTenantId(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        String tenantId = this.getTenantIdFromContext(ctx);
        if (tenantId.isBlank()) {
            ctx.fail((Throwable)new ClientErrorException(400, String.format("'%s' param cannot be empty", "tenant-id")));
        }
        payload.put("tenant-id", tenantId);
        ctx.put("KEY_REQUEST_BODY", (Object)payload);
        ctx.next();
    }

    private String getTenantIdFromContext(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        return Optional.ofNullable(this.getTenantParam(ctx)).orElse(TenantManagementHttpEndpoint.getTenantParamFromPayload(payload));
    }

    private void createTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        String location = String.format("/%s/", this.getName());
        this.doTenantHttpRequest(ctx, tenantId, "create", status -> status == 201, (response, responseMessage) -> response.putHeader(HttpHeaders.LOCATION, (CharSequence)(location + responseMessage.getTenant())));
    }

    private void getTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        this.doTenantHttpRequest(ctx, tenantId, "get", status -> status == 200, null);
    }

    private void updateTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        this.doTenantHttpRequest(ctx, tenantId, "update", status -> status == 204, (response, payload) -> response.putHeader(HttpHeaders.ETAG, (CharSequence)payload.getResourceVersion()));
    }

    private void deleteTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        this.doTenantHttpRequest(ctx, tenantId, "delete", status -> status == 204, null);
    }

    private void doTenantHttpRequest(RoutingContext ctx, String tenantId, String action, IntPredicate successfulOutcomeFilter, BiConsumer<HttpServerResponse, EventBusMessage> httpServerResponseHandler) {
        this.logger.debug("http request [{}] for tenant [tenant: {}]", (Object)action, (Object)tenantId);
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        JsonObject requestMsg = EventBusMessage.forOperation((String)action).setTenant(tenantId).setJsonPayload(payload).setResourceVersion((String)ctx.get("KEY_RESOURCE_VERSION")).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, successfulOutcomeFilter, httpServerResponseHandler));
    }

    private static String getTenantParamFromPayload(JsonObject payload) {
        return payload != null ? (String)payload.remove("tenant-id") : null;
    }
}

