/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.EnumSet;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.EventBusMessage;
import org.springframework.beans.factory.annotation.Autowired;

public final class DeviceManagementHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    @Autowired
    public DeviceManagementHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Override
    protected String getEventBusAddress() {
        return "device.mgmt.in";
    }

    @Override
    public String getName() {
        return String.format("%s/%s", "v1", "devices");
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenant = String.format("/%s/:%s", this.getName(), "tenant_id");
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", this.getName(), "tenant_id", "device_id");
        router.route(pathWithTenant).handler((Handler)this.createCorsHandler(((ServiceConfigProperties)this.config).getCorsAllowedOrigin(), EnumSet.of(HttpMethod.POST)));
        router.route(pathWithTenantAndDeviceId).handler((Handler)this.createDefaultCorsHandler(((ServiceConfigProperties)this.config).getCorsAllowedOrigin()));
        router.post(pathWithTenant).handler(this::extractOptionalJsonPayload).handler(this::doCreateDevice);
        router.post(pathWithTenantAndDeviceId).handler(this::extractOptionalJsonPayload).handler(this::doCreateDevice);
        router.get(pathWithTenantAndDeviceId).handler(this::doGetDevice);
        router.put(pathWithTenantAndDeviceId).handler(this::extractRequiredJsonPayload).handler(this::extractIfMatchVersionParam).handler(this::doUpdateDevice);
        router.delete(pathWithTenantAndDeviceId).handler(this::extractIfMatchVersionParam).handler(this::doDeleteDevice);
    }

    private void doGetDevice(RoutingContext ctx) {
        String deviceId = this.getDeviceIdParam(ctx);
        String tenantId = this.getTenantParam(ctx);
        HttpServerResponse response = ctx.response();
        JsonObject requestMsg = EventBusMessage.forOperation((String)"get").setTenant(tenantId).setDeviceId(deviceId).toJson();
        this.sendAction(ctx, requestMsg, (status, result) -> {
            response.setStatusCode(status.intValue());
            switch (status) {
                case 200: {
                    ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)result.getResourceVersion());
                    HttpUtils.setResponseBody(ctx.response(), result.getJsonPayload());
                }
            }
            response.end();
        });
    }

    private void doCreateDevice(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        if (payload == null) {
            HttpUtils.badRequest(ctx, "missing body");
            return;
        }
        String deviceId = this.getDeviceIdParam(ctx);
        if (deviceId != null && !(deviceId instanceof String)) {
            HttpUtils.badRequest(ctx, String.format("'%s' must be a string", "device-id"));
        }
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("creating device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
        JsonObject requestMsg = EventBusMessage.forOperation((String)"create").setTenant(tenantId).setDeviceId(deviceId).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, (int status) -> status == 201, (HttpServerResponse response, EventBusMessage responseMessage) -> response.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s/%s", this.getName(), tenantId, responseMessage.getDeviceId()))));
    }

    private void doUpdateDevice(RoutingContext ctx) {
        String deviceId = this.getDeviceIdParam(ctx);
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        if (payload != null) {
            payload.remove("device-id");
        }
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("updating device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
        JsonObject requestMsg = EventBusMessage.forOperation((String)"update").setTenant(tenantId).setDeviceId(deviceId).setJsonPayload(payload).setResourceVersion((String)ctx.get("KEY_RESOURCE_VERSION")).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx));
    }

    private void doDeleteDevice(RoutingContext ctx) {
        String deviceId = this.getDeviceIdParam(ctx);
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("removing device [tenant: {}, device: {}]", (Object)tenantId, (Object)deviceId);
        JsonObject requestMsg = EventBusMessage.forOperation((String)"delete").setTenant(tenantId).setDeviceId(deviceId).setResourceVersion((String)ctx.get("KEY_RESOURCE_VERSION")).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx));
    }
}

