/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import org.eclipse.hono.service.management.credentials.GenericCredential;
import org.eclipse.hono.service.management.credentials.PasswordCredential;
import org.eclipse.hono.service.management.credentials.PskCredential;
import org.eclipse.hono.service.management.credentials.X509CertificateCredential;

public class CredentialTypeResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromValueAndType(Object obj, Class<?> subType) {
        if (obj instanceof GenericCredential) {
            return ((GenericCredential)obj).getType();
        }
        if (obj instanceof PasswordCredential) {
            return "hashed-password";
        }
        if (obj instanceof PskCredential) {
            return "psk";
        }
        if (obj instanceof X509CertificateCredential) {
            return "x509-cert";
        }
        return null;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        switch (id) {
            case "hashed-password": {
                return context.constructSpecializedType(this.baseType, PasswordCredential.class);
            }
            case "psk": {
                return context.constructSpecializedType(this.baseType, PskCredential.class);
            }
            case "x509-cert": {
                return context.constructSpecializedType(this.baseType, X509CertificateCredential.class);
            }
        }
        return context.constructSpecializedType(this.baseType, GenericCredential.class);
    }
}

