/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.vertx.ext.web.TracingHandler;
import io.opentracing.noop.NoopSpanContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.BasicAuthHandlerImpl;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import org.eclipse.hono.service.http.AuthHandlerTools;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.tracing.TracingHelper;

public class HonoBasicAuthHandler
extends BasicAuthHandlerImpl {
    private final Tracer tracer;

    public HonoBasicAuthHandler(AuthProvider authProvider, String realm, Tracer tracer) {
        super(authProvider, realm);
        this.tracer = tracer;
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (ctx.response().ended()) {
            return;
        }
        AuthHandlerTools.processException(ctx, exception, this.authenticateHeader(ctx));
    }

    public void parseCredentials(final RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        RoutingContextDecorator routingContextDecorator = new RoutingContextDecorator(context.currentRoute(), context){

            public void fail(Throwable throwable) {
                HttpUtils.badRequest(context, "Malformed authorization header");
            }
        };
        super.parseCredentials((RoutingContext)routingContextDecorator, ar -> {
            SpanContext spanContext;
            if (ar.succeeded() && (spanContext = TracingHandler.serverSpanContext((RoutingContext)context)) != null && !(spanContext instanceof NoopSpanContext)) {
                TracingHelper.injectSpanContext((Tracer)this.tracer, (SpanContext)spanContext, (JsonObject)((JsonObject)ar.result()));
            }
            handler.handle(ar);
        });
    }
}

