/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.contrib.vertx.ext.web.WebSpanDecorator;
import io.opentracing.tag.Tags;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMetaDataDecorator
extends WebSpanDecorator.StandardTags {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentMetaDataDecorator.class);
    private final Map<String, String> tags;

    public ComponentMetaDataDecorator() {
        this(new HashMap<String, String>(0));
    }

    public ComponentMetaDataDecorator(Map<String, String> customTags) {
        this.tags = Collections.unmodifiableMap(Objects.requireNonNull(customTags));
    }

    public void onRequest(HttpServerRequest request, Span span) {
        LOG.trace("starting span for request [method: {}, URI: {}", (Object)request.method(), (Object)request.absoluteURI());
        Tags.HTTP_METHOD.set(span, request.method().toString());
        Tags.HTTP_URL.set(span, request.absoluteURI());
        this.tags.forEach((key, value) -> span.setTag(key, value));
    }

    public void onReroute(HttpServerRequest request, Span span) {
        LOG.trace("logging re-routed request [method: {}, URI: {}", (Object)request.method(), (Object)request.absoluteURI());
        HashMap<String, String> logs = new HashMap<String, String>(3);
        logs.put("event", "reroute");
        logs.put(Tags.HTTP_URL.getKey(), request.absoluteURI());
        logs.put(Tags.HTTP_METHOD.getKey(), request.method().toString());
        span.log(logs);
    }

    public void onResponse(HttpServerRequest request, Span span) {
        LOG.trace("setting status code of response to request [method: {}, URI: {}", (Object)request.method(), (Object)request.absoluteURI());
        Tags.HTTP_STATUS.set(span, Integer.valueOf(request.response().getStatusCode()));
    }

    public void onFailure(Throwable throwable, HttpServerResponse response, Span span) {
        LOG.trace("logging failed processing of request");
        TracingHelper.logError((Span)span, (Throwable)throwable);
    }
}

