/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.deviceconnection;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.deviceconnection.DeviceConnectionService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.DeviceConnectionConstants;
import org.eclipse.hono.util.DeviceConnectionResult;
import org.eclipse.hono.util.EventBusMessage;

public abstract class EventBusDeviceConnectionAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_GET_LAST_GATEWAY = "get last known gateway";
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";

    protected abstract DeviceConnectionService getService();

    @Override
    protected final String getEventBusAddress() {
        return "devcon.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (DeviceConnectionConstants.DeviceConnectionAction.from((String)request.getOperation())) {
            case GET_LAST_GATEWAY: {
                return this.processGetLastGatewayRequest(request);
            }
            case SET_LAST_GATEWAY: {
                return this.processSetLastGatewayRequest(request);
            }
        }
        return this.processCustomOperationMessage(request);
    }

    protected Future<EventBusMessage> processGetLastGatewayRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        SpanContext spanContext = request.getSpanContext();
        Span span = this.newChildSpan(SPAN_NAME_GET_LAST_GATEWAY, spanContext, tenantId, deviceId, null);
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Future result = Future.future();
            this.log.debug("getting last known gateway for tenant [{}], device [{}]", (Object)tenantId, (Object)deviceId);
            this.getService().getLastKnownGatewayForDevice(tenantId, deviceId, span, (Handler<AsyncResult<DeviceConnectionResult>>)result);
            resultFuture = result.map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processSetLastGatewayRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String gatewayId = request.getGatewayId();
        SpanContext spanContext = request.getSpanContext();
        Span span = this.newChildSpan(SPAN_NAME_SET_LAST_GATEWAY, spanContext, tenantId, deviceId, gatewayId);
        if (tenantId == null || deviceId == null || gatewayId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or gateway");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Future result = Future.future();
            this.log.debug("setting last known gateway for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceId, gatewayId});
            this.getService().setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, span, (Handler<AsyncResult<DeviceConnectionResult>>)result);
            resultFuture = result.map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected final Span newChildSpan(String operationName, SpanContext spanContext, String tenantId, String deviceId, String gatewayId) {
        Objects.requireNonNull(operationName);
        Tracer.SpanBuilder spanBuilder = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)operationName).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), ((Object)((Object)this)).getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "server");
        if (tenantId != null) {
            spanBuilder.withTag("tenant_id", tenantId);
        }
        if (deviceId != null) {
            spanBuilder.withTag("device_id", deviceId);
        }
        if (gatewayId != null) {
            spanBuilder.withTag("gateway_id", gatewayId);
        }
        return spanBuilder.start();
    }

    protected Future<EventBusMessage> processCustomOperationMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }
}

