/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Vertx;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import java.util.Objects;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.service.auth.EventBusAuthenticationService;
import org.eclipse.hono.service.auth.HonoSaslAuthenticator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class HonoSaslAuthenticatorFactory
implements ProtonSaslAuthenticatorFactory {
    private final AuthenticationService authenticationService;

    @Autowired
    public HonoSaslAuthenticatorFactory(Vertx vertx, @Qualifier(value="authentication") AuthTokenHelper validator) {
        this(new EventBusAuthenticationService(vertx, validator));
    }

    public HonoSaslAuthenticatorFactory(AuthenticationService authService) {
        this.authenticationService = Objects.requireNonNull(authService);
    }

    public ProtonSaslAuthenticator create() {
        return new HonoSaslAuthenticator(this.authenticationService);
    }
}

