/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.proton.ProtonConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.Symbol;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressAuthzHelper {
    public static final Symbol CAPABILITY_ADDRESS_AUTHZ = Symbol.valueOf((String)"ADDRESS-AUTHZ");
    public static final Symbol PROPERTY_ADDRESS_AUTHZ = Symbol.valueOf((String)"address-authz");
    public static final Symbol PROPERTY_AUTH_IDENTITY = Symbol.valueOf((String)"authenticated-identity");
    public static final Symbol PROPERTY_CLIENT_VERSION = Symbol.valueOf((String)"version");
    private static final int IDX_MAJOR_VERSION = 0;
    private static final int IDX_MINOR_VERSION = 1;
    private static final int IDX_PATCH_VERSION = 2;
    private static final Logger LOG = LoggerFactory.getLogger(AddressAuthzHelper.class);

    private AddressAuthzHelper() {
    }

    public static boolean isAddressAuthzCapabilitySet(ProtonConnection connection) {
        Symbol[] remoteDesiredCapabilities = connection.getRemoteDesiredCapabilities();
        return remoteDesiredCapabilities != null && Arrays.stream(remoteDesiredCapabilities).anyMatch(symbol -> symbol.equals(CAPABILITY_ADDRESS_AUTHZ));
    }

    public static void processAddressAuthzCapability(ProtonConnection connection) {
        Map remoteProperties;
        if (LOG.isDebugEnabled() && (remoteProperties = connection.getRemoteProperties()) != null) {
            String props = remoteProperties.entrySet().stream().map(entry -> String.format("[%s: %s]", entry.getKey(), entry.getValue().toString())).collect(Collectors.joining(", "));
            LOG.debug("client connection [container: {}] includes properties: {}", (Object)connection.getRemoteContainer(), (Object)props);
        }
        HonoUser clientPrincipal = Constants.getClientPrincipal((ProtonConnection)connection);
        Map<String, String[]> permissions = AddressAuthzHelper.getPermissionsFromAuthorities(clientPrincipal.getAuthorities());
        HashMap<Symbol, Object> properties = new HashMap<Symbol, Object>();
        boolean isLegacy = AddressAuthzHelper.isLegacyClient(connection);
        if (isLegacy) {
            properties.put(PROPERTY_AUTH_IDENTITY, clientPrincipal.getName());
        } else {
            properties.put(PROPERTY_AUTH_IDENTITY, Collections.singletonMap("sub", clientPrincipal.getName()));
        }
        properties.put(PROPERTY_ADDRESS_AUTHZ, permissions);
        connection.setProperties(properties);
        connection.setOfferedCapabilities(new Symbol[]{CAPABILITY_ADDRESS_AUTHZ});
        LOG.debug("transferring {} permissions of client [container: {}, user: {}] in open frame [legacy format: {}]", new Object[]{permissions.size(), connection.getRemoteContainer(), clientPrincipal.getName(), isLegacy});
    }

    private static boolean isLegacyClient(ProtonConnection con) {
        return Optional.ofNullable(con.getRemoteProperties()).map(props -> {
            Object obj = props.get(PROPERTY_CLIENT_VERSION);
            if (obj instanceof String) {
                int[] version = AddressAuthzHelper.parseVersionString((String)obj);
                return version[0] == 1 && version[1] < 4;
            }
            return false;
        }).orElse(false);
    }

    private static int[] parseVersionString(String version) {
        int[] result = new int[]{0, 0, 0};
        String[] versionNumbers = version.split("\\.", 3);
        try {
            if (versionNumbers.length > 0) {
                result[0] = Integer.parseInt(versionNumbers[0]);
            }
            if (versionNumbers.length > 1) {
                result[1] = Integer.parseInt(versionNumbers[1]);
            }
            if (versionNumbers.length > 2) {
                result[2] = Integer.parseInt(versionNumbers[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.debug("client Dispatch Router version [major: {}, minor: {}, patch: {}]", new Object[]{result[0], result[1], result[2]});
        return result;
    }

    private static Map<String, String[]> getPermissionsFromAuthorities(Authorities authorities) {
        return authorities.asMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("r:")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring("r:".length()), entry -> AddressAuthzHelper.getAuthorities((String)entry.getValue())));
    }

    private static String[] getAuthorities(String activities) {
        Set result = activities.chars().mapToObj(act -> {
            switch (act) {
                case 82: {
                    return "recv";
                }
                case 87: {
                    return "send";
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return (String[])result.toArray(String[]::new);
    }
}

