/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.service.AbstractBaseApplication;
import org.eclipse.hono.service.AbstractServiceBase;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractApplication
extends AbstractBaseApplication {
    private final Set<ObjectFactory<? extends AbstractServiceBase<?>>> serviceFactories = new HashSet();

    @Override
    protected void preFlightCheck() throws IllegalStateException {
        if (this.serviceFactories.isEmpty()) {
            throw new IllegalStateException("no service factory has been configured");
        }
    }

    @Autowired
    public final void addServiceFactories(Set<ObjectFactory<? extends AbstractServiceBase<?>>> factories) {
        Objects.requireNonNull(factories);
        this.serviceFactories.addAll(factories);
        this.log.debug("added {} service factories", (Object)factories.size());
    }

    protected Future<?> deployRequiredVerticles(int maxInstances) {
        return Future.succeededFuture();
    }

    private Future<?> deployServiceVerticles(int maxInstances) {
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setInstances(maxInstances);
        ArrayList<Future> deploymentTracker = new ArrayList<Future>();
        for (ObjectFactory<? extends AbstractServiceBase<?>> objectFactory : this.serviceFactories) {
            Future deployTracker = Future.future();
            AbstractServiceBase serviceInstance = (AbstractServiceBase)objectFactory.getObject();
            this.preDeploy(serviceInstance);
            this.log.debug("deploying service instance [type: {}]", (Object)serviceInstance.getClass().getName());
            this.getVertx().deployVerticle((Verticle)serviceInstance, deploymentOptions, (Handler)deployTracker);
            deploymentTracker.add(deployTracker.map(id -> {
                this.postDeploy(serviceInstance);
                return id;
            }));
        }
        return CompositeFuture.all(deploymentTracker);
    }

    protected void preDeploy(AbstractServiceBase<?> serviceInstance) {
    }

    protected void postDeploy(AbstractServiceBase<?> serviceInstance) {
    }

    @Override
    protected Future<?> deployVerticles() {
        return super.deployVerticles().compose(s -> this.deployRequiredVerticles(this.getConfig().getMaxInstances())).compose(s -> this.deployServiceVerticles(this.getConfig().getMaxInstances()));
    }
}

